import { memo } from 'react';
import { createPortal } from 'react-dom';
const createModalRoot = () => {
    const id = 'modal-root';
    const existing = document.getElementById(id);
    if (existing)
        return existing;
    const newOne = document.createElement('div');
    newOne.id = id;
    document.body.append(newOne);
    return newOne;
};
let modalRoot = null;
const ModalPortal = ({ children }) => {
    if (!modalRoot) {
        modalRoot = createModalRoot();
    }
    return createPortal(children, modalRoot);
};
export default memo(ModalPortal);
//# sourceMappingURL=ModalPortal.js.map