import { jsx as _jsx } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { useCallback, useEffect, useRef } from 'react';
const useEscapeKey = (onDismiss) => {
    useEffect(() => {
        const closeOnEsc = (e) => {
            if (e.key !== 'Escape') {
                return;
            }
            e.stopPropagation();
            onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss();
        };
        window.addEventListener('keydown', closeOnEsc);
        return () => {
            window.removeEventListener('keydown', closeOnEsc);
        };
    }, [onDismiss]);
};
const isAtBackdropChildren = (e, ref) => {
    var _a;
    const backdrop = ref.current;
    const { parentElement } = e.target;
    return (_a = (Boolean(parentElement) && (backdrop === null || backdrop === void 0 ? void 0 : backdrop.contains(parentElement)))) !== null && _a !== void 0 ? _a : false;
};
const useOutsideClick = (ref, onDismiss) => {
    const hasClicked = useRef(false);
    const onMouseDown = useCallback((e) => {
        if (isAtBackdropChildren(e, ref)) {
            hasClicked.current = false;
            return;
        }
        hasClicked.current = true;
    }, [ref]);
    const onMouseUp = useCallback((e) => {
        if (isAtBackdropChildren(e, ref)) {
            hasClicked.current = false;
            return;
        }
        if (!hasClicked.current) {
            return;
        }
        hasClicked.current = false;
        e.stopPropagation();
        onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss();
    }, [onDismiss, ref]);
    return {
        onMouseDown,
        onMouseUp,
    };
};
const ModalBackdrop = ({ children, onDismiss }) => {
    const ref = useRef(null);
    useEscapeKey(onDismiss);
    const { onMouseDown, onMouseUp } = useOutsideClick(ref, onDismiss);
    return (_jsx(Box, { ref: ref, children: children, className: 'rcx-modal__backdrop', position: 'fixed', zIndex: 9999, inset: 0, display: 'flex', flexDirection: 'column', onMouseDown: onMouseDown, onMouseUp: onMouseUp }));
};
export default ModalBackdrop;
//# sourceMappingURL=ModalBackdrop.js.map