var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Label, CheckBox } from '@rocket.chat/fuselage';
import { useUserPreference, useTranslation, useEndpoint } from '@rocket.chat/ui-contexts';
import { useId, useState } from 'react';
function withDoNotAskAgain(Component) {
    var _a, _b;
    const WrappedComponent = function (_a) {
        var { onConfirm, dontAskAgain } = _a, props = __rest(_a, ["onConfirm", "dontAskAgain"]);
        const t = useTranslation();
        const dontAskAgainId = useId();
        const dontAskAgainList = useUserPreference('dontAskAgainList');
        const { action, label } = dontAskAgain;
        const saveFn = useEndpoint('POST', '/v1/users.setPreferences');
        const [state, setState] = useState(false);
        const handleConfirm = () => __awaiter(this, void 0, void 0, function* () {
            try {
                if (state) {
                    yield saveFn({ data: { dontAskAgainList: [...(dontAskAgainList || []), { action, label }] } });
                }
                yield onConfirm();
            }
            catch (e) {
                console.error(e);
            }
        });
        const onChange = () => {
            setState(!state);
        };
        return (_jsx(Component, Object.assign({}, props, { dontAskAgain: _jsxs(Box, { display: 'flex', flexDirection: 'row', children: [_jsx(CheckBox, { id: dontAskAgainId, checked: state, onChange: onChange, name: 'dont_ask_again' }), _jsx(Label, { color: 'annotation', fontScale: 'p2', mis: 8, htmlFor: dontAskAgainId, children: t('Dont_ask_me_again') })] }), onConfirm: handleConfirm })));
    };
    WrappedComponent.displayName = `withDoNotAskAgain(${(_b = (_a = Component.displayName) !== null && _a !== void 0 ? _a : Component.name) !== null && _b !== void 0 ? _b : 'Component'})`;
    return WrappedComponent;
}
export { withDoNotAskAgain };
//# sourceMappingURL=withDoNotAskAgain.js.map