import { jsx as _jsx } from "react/jsx-runtime";
import { Badge } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { usePreferenceFeaturePreviewList } from '../../hooks/usePreferenceFeaturePreviewList';
const FeaturePreviewBadge = () => {
    const { t } = useTranslation();
    const { unseenFeatures } = usePreferenceFeaturePreviewList();
    if (!unseenFeatures) {
        return null;
    }
    return (_jsx(Badge, { variant: 'primary', "aria-label": t('Unseen_features'), children: unseenFeatures }));
};
export default FeaturePreviewBadge;
//# sourceMappingURL=FeaturePreviewBadge.js.map