import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { Children, Suspense, cloneElement } from 'react';
import { useFeaturePreview } from '../../hooks/useFeaturePreview';
export const FeaturePreview = ({ feature, disabled = false, children, }) => {
    const featureToggleEnabled = useFeaturePreview(feature) && !disabled;
    const toggledChildren = Children.map(children, (child) => cloneElement(child, {
        featureToggleEnabled,
    }));
    return _jsx(Suspense, { fallback: null, children: toggledChildren });
};
export const FeaturePreviewOn = ({ children, featureToggleEnabled }) => (_jsx(_Fragment, { children: featureToggleEnabled && children }));
export const FeaturePreviewOff = ({ children, featureToggleEnabled }) => (_jsx(_Fragment, { children: !featureToggleEnabled && children }));
//# sourceMappingURL=FeaturePreview.js.map