var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Field, FieldLabel, FieldRow, FieldError, Select, TextInput } from '@rocket.chat/fuselage';
import { useCallback, useId, useMemo } from 'react';
import { Controller, useFormState, get } from 'react-hook-form';
import { useTranslation } from 'react-i18next';
const FIELD_TYPES = {
    select: Select,
    text: TextInput,
};
const CustomField = (_a) => {
    var _b;
    var { name, type, control, label, required, defaultValue, options = [] } = _a, props = __rest(_a, ["name", "type", "control", "label", "required", "defaultValue", "options"]);
    const { t } = useTranslation();
    const { errors } = useFormState({ control });
    const fieldId = useId();
    const Component = (_b = FIELD_TYPES[type]) !== null && _b !== void 0 ? _b : null;
    const selectOptions = useMemo(() => options.length > 0 && options[0] instanceof Array ? options : options.map((option) => [option, option, defaultValue === option]), [defaultValue, options]);
    const validateRequired = useCallback((value) => (required ? typeof value === 'string' && !!value.trim() : true), [required]);
    const getErrorMessage = useCallback((error) => {
        switch (error === null || error === void 0 ? void 0 : error.type) {
            case 'required':
                return t('Required_field', { field: label || name });
            case 'minLength':
                return t('Min_length_is', { postProcess: 'sprintf', sprintf: [props === null || props === void 0 ? void 0 : props.minLength] });
            case 'maxLength':
                return t('Max_length_is', { postProcess: 'sprintf', sprintf: [props === null || props === void 0 ? void 0 : props.maxLength] });
        }
    }, [label, name, props === null || props === void 0 ? void 0 : props.maxLength, props === null || props === void 0 ? void 0 : props.minLength, t]);
    const error = get(errors, name);
    const errorMessage = useMemo(() => getErrorMessage(error), [error, getErrorMessage]);
    if (!Component) {
        return null;
    }
    return (_jsx(Controller, { name: name, control: control, defaultValue: defaultValue !== null && defaultValue !== void 0 ? defaultValue : '', rules: { minLength: props.minLength, maxLength: props.maxLength, validate: { required: validateRequired } }, render: ({ field }) => (_jsxs(Field, { "rcx-field-group__item": true, children: [_jsx(FieldLabel, { is: 'span', id: fieldId, required: required, children: label || t(name) }), _jsx(FieldRow, { children: _jsx(Component, Object.assign({}, props, field, { "aria-labelledby": fieldId, "aria-describedby": errorMessage && `${fieldId}-error`, error: errorMessage, options: selectOptions, flexGrow: 1 })) }), errorMessage ? (_jsx(FieldError, { "aria-live": 'assertive', id: `${fieldId}-error`, children: errorMessage })) : null] })) }));
};
// eslint-disable-next-line react/no-multi-comp
export const CustomFieldsForm = ({ formName, formControl, metadata }) => (_jsx(_Fragment, { children: metadata.map((_a) => {
        var { name: fieldName, label } = _a, props = __rest(_a, ["name", "label"]);
        return (_jsx(CustomField, Object.assign({ name: `${formName}.${fieldName}`, control: formControl, label: label !== null && label !== void 0 ? label : fieldName }, props), fieldName));
    }) }));
//# sourceMappingURL=CustomFieldsForm.js.map