var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { useUserAvatarPath } from '@rocket.chat/ui-contexts';
import { memo } from 'react';
import BaseAvatar from './BaseAvatar';
const UserAvatar = (_a) => {
    var { username, userId, etag } = _a, rest = __rest(_a, ["username", "userId", "etag"]);
    const getUserAvatarPath = useUserAvatarPath();
    if (userId) {
        const { url = getUserAvatarPath({ userId, etag }) } = rest, props = __rest(rest, ["url"]);
        return _jsx(BaseAvatar, Object.assign({ url: url }, props));
    }
    if (username) {
        const { url = getUserAvatarPath({ username, etag }) } = rest, props = __rest(rest, ["url"]);
        return _jsx(BaseAvatar, Object.assign({ url: url, "data-username": username, title: username }, props));
    }
    // TODO: We should throw an Error after fixing the issue in Composer passing the username undefined
    return null;
};
export default memo(UserAvatar);
//# sourceMappingURL=UserAvatar.js.map