var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { Avatar, Skeleton } from '@rocket.chat/fuselage';
import { useEffectEvent, usePrevious } from '@rocket.chat/fuselage-hooks';
import { useState } from 'react';
const BaseAvatar = (_a) => {
    var { url, onLoad, onError, size } = _a, props = __rest(_a, ["url", "onLoad", "onError", "size"]);
    const [unloaded, setUnloaded] = useState(false);
    const prevUrl = usePrevious(url);
    const handleLoad = useEffectEvent((event) => {
        setUnloaded(false);
        onLoad === null || onLoad === void 0 ? void 0 : onLoad(event);
    });
    const handleError = useEffectEvent((event) => {
        setUnloaded(true);
        onError === null || onError === void 0 ? void 0 : onError(event);
    });
    if (unloaded && url === prevUrl) {
        return _jsx(Skeleton, Object.assign({ "aria-hidden": 'true', variant: 'rect', width: size, height: size }, props));
    }
    return _jsx(Avatar, Object.assign({ "aria-hidden": 'true', onLoad: handleLoad, onError: handleError, url: url, size: size }, props));
};
export default BaseAvatar;
//# sourceMappingURL=BaseAvatar.js.map