"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertSubObjectsIntoPaths = convertSubObjectsIntoPaths;
const isRecord_1 = require("./isRecord");
function convertSubObjectsIntoPaths(object, parentPath) {
    return Object.fromEntries(Object.keys(object).flatMap((key) => {
        const value = object[key];
        const fullKey = parentPath ? `${parentPath}.${key}` : key;
        if ((0, isRecord_1.isRecord)(value)) {
            const flattened = convertSubObjectsIntoPaths(value, fullKey);
            return Object.keys(flattened).map((newKey) => [newKey, flattened[newKey]]);
        }
        return [[fullKey, value]];
    }));
}
//# sourceMappingURL=convertSubObjectsIntoPaths.js.map