var htmlEntityCodeToCharacter = {
    nbsp: ' ',
    cent: '¢',
    pound: '£',
    yen: '¥',
    euro: '€',
    copy: '©',
    reg: '®',
    trade: '™',
    lt: '<',
    gt: '>',
    quot: '"',
    amp: '&',
    apos: "'",
};
var toString = function (object) { return (object ? "".concat(object) : ''); };
var isHtmlEntityCode = function (htmlEntityCode) {
    return htmlEntityCode in htmlEntityCodeToCharacter;
};
export var unescapeHTML = function (str) {
    return toString(str).replace(/\&([^;]{1,10});/g, function (entity, htmlEntityCode) {
        var match;
        if (isHtmlEntityCode(htmlEntityCode)) {
            return htmlEntityCodeToCharacter[htmlEntityCode];
        }
        match = htmlEntityCode.match(/^#x([\da-fA-F]+)$/);
        if (match) {
            return String.fromCharCode(parseInt(match[1], 16));
        }
        match = htmlEntityCode.match(/^#(\d+)$/);
        if (match) {
            return String.fromCharCode(~~match[1]);
        }
        return entity;
    });
};
//# sourceMappingURL=unescapeHTML.js.map