import { capitalize } from './capitalize';
describe('capitalize', function () {
    it('should convert "xyz" to "Xyz"', function () {
        expect(capitalize('xyz')).toBe('Xyz');
    });
    it('should convert "xyz xyz" to "Xyz xyz"', function () {
        expect(capitalize('xyz xyz')).toBe('Xyz xyz');
    });
    it('should convert " xyz" to " xyz"', function () {
        expect(capitalize(' xyz')).toBe(' xyz');
    });
    it('should convert undefined to ""', function () {
        expect(capitalize(undefined)).toBe('');
    });
    it('should convert null to ""', function () {
        expect(capitalize(null)).toBe('');
    });
    it('should convert false to ""', function () {
        expect(capitalize(false)).toBe('');
    });
    it('should convert true to ""', function () {
        expect(capitalize(true)).toBe('');
    });
    it('should convert 0 to ""', function () {
        expect(capitalize(0)).toBe('');
    });
    it('should convert 1 to ""', function () {
        expect(capitalize(1)).toBe('');
    });
});
//# sourceMappingURL=capitalize.spec.js.map