"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var escapeRegExp_1 = require("./escapeRegExp");
describe('escapeRegExp', function () {
    it('should keep strings with letters only unchanged', function () {
        expect((0, escapeRegExp_1.escapeRegExp)('word')).toBe('word');
    });
    it('should escape slashes', function () {
        expect((0, escapeRegExp_1.escapeRegExp)('/slashes/')).toBe('\\/slashes\\/');
        expect((0, escapeRegExp_1.escapeRegExp)('\\backslashes\\')).toBe('\\\\backslashes\\\\');
        expect((0, escapeRegExp_1.escapeRegExp)('\\border of word')).toBe('\\\\border of word');
    });
    it('should escape special group', function () {
        var _a, _b, _c, _d, _e, _f, _g;
        expect((0, escapeRegExp_1.escapeRegExp)('(?:non-capturing)')).toBe('\\(\\?\\:non\\-capturing\\)');
        expect((_a = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('(?:'), "([^)]+)")).exec('(?:non-capturing)')) === null || _a === void 0 ? void 0 : _a[1]).toBe('non-capturing');
        expect((0, escapeRegExp_1.escapeRegExp)('(?=positive-lookahead)')).toBe('\\(\\?\\=positive\\-lookahead\\)');
        expect((_b = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('(?='), "([^)]+)")).exec('(?=positive-lookahead)')) === null || _b === void 0 ? void 0 : _b[1]).toBe('positive-lookahead');
        expect((0, escapeRegExp_1.escapeRegExp)('(?<=positive-lookbehind)')).toBe('\\(\\?<\\=positive\\-lookbehind\\)');
        expect((_c = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('(?<='), "([^)]+)")).exec('(?<=positive-lookbehind)')) === null || _c === void 0 ? void 0 : _c[1]).toBe('positive-lookbehind');
        expect((0, escapeRegExp_1.escapeRegExp)('(?!negative-lookahead)')).toBe('\\(\\?\\!negative\\-lookahead\\)');
        expect((_d = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('(?!'), "([^)]+)")).exec('(?!negative-lookahead)')) === null || _d === void 0 ? void 0 : _d[1]).toBe('negative-lookahead');
        expect((0, escapeRegExp_1.escapeRegExp)('(?<!negative-lookbehind)')).toBe('\\(\\?<\\!negative\\-lookbehind\\)');
        expect((_e = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('(?<!'), "([^)]+)")).exec('(?<!negative-lookbehind)')) === null || _e === void 0 ? void 0 : _e[1]).toBe('negative-lookbehind');
        expect((0, escapeRegExp_1.escapeRegExp)('[\\w]+')).toBe('\\[\\\\w\\]\\+');
        expect((_f = new RegExp("".concat((0, escapeRegExp_1.escapeRegExp)('['), "([^\\]]+)")).exec('[character class]')) === null || _f === void 0 ? void 0 : _f[1]).toBe('character class');
        expect((_g = new RegExp((0, escapeRegExp_1.escapeRegExp)('<div>')).exec('<td><div></td>')) === null || _g === void 0 ? void 0 : _g[0]).toBe('<div>');
        expect((0, escapeRegExp_1.escapeRegExp)('{5,2}')).toBe('\\{5,2\\}');
        expect((0, escapeRegExp_1.escapeRegExp)('/([.*+?^=!:${}()|[\\]\\/\\\\])/g')).toBe('\\/\\(\\[\\.\\*\\+\\?\\^\\=\\!\\:\\$\\{\\}\\(\\)\\|\\[\\\\\\]\\\\\\/\\\\\\\\\\]\\)\\/g');
    });
    it('should not escape whitespace', function () {
        expect((0, escapeRegExp_1.escapeRegExp)('\\n\\r\\t')).toBe('\\\\n\\\\r\\\\t');
        expect((0, escapeRegExp_1.escapeRegExp)('\n\r\t')).toBe('\n\r\t');
    });
    it('ignores errors from non-string argument', function () {
        expect(function () { return (0, escapeRegExp_1.escapeRegExp)(false); }).not.toThrow();
        expect(function () { return escapeRegExp_1.escapeRegExp(); }).not.toThrow();
        expect(function () { return (0, escapeRegExp_1.escapeRegExp)(null); }).not.toThrow();
        expect(function () { return (0, escapeRegExp_1.escapeRegExp)(42); }).not.toThrow();
    });
});
//# sourceMappingURL=escapeRegExp.spec.js.map