"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var escapeHTML_1 = require("./escapeHTML");
describe('escapeHTML', function () {
    it('works', function () {
        expect((0, escapeHTML_1.escapeHTML)('<div>Blah & "blah" & \'blah\'</div>')).toBe('&lt;div&gt;Blah &amp; &quot;blah&quot; &amp; &#39;blah&#39;&lt;/div&gt;');
        expect((0, escapeHTML_1.escapeHTML)('&lt;')).toBe('&amp;lt;');
        expect((0, escapeHTML_1.escapeHTML)(' ')).toBe(' ');
        expect((0, escapeHTML_1.escapeHTML)('¢')).toBe('&cent;');
        expect((0, escapeHTML_1.escapeHTML)('¢ £ ¥ € © ® ™')).toBe('&cent; &pound; &yen; &euro; &copy; &reg; &trade;');
        expect((0, escapeHTML_1.escapeHTML)(5)).toBe('5');
        expect((0, escapeHTML_1.escapeHTML)('')).toBe('');
        expect((0, escapeHTML_1.escapeHTML)(null)).toBe('');
        expect((0, escapeHTML_1.escapeHTML)(undefined)).toBe('');
    });
});
//# sourceMappingURL=escapeHTML.spec.js.map