"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseRequestOptions = parseRequestOptions;
const jsonParser = (options) => {
    if (!options) {
        return {};
    }
    try {
        if (typeof options.body === 'object' && !Buffer.isBuffer(options.body)) {
            options.body = JSON.stringify(options.body);
            options.headers = {
                ...options.headers,
                'Content-Type': 'application/json', // force content type to be json
            };
        }
    }
    catch (e) {
        // Body is not JSON, do nothing
    }
    return options;
};
const urlencodedParser = (options) => {
    return options;
};
const getParser = (contentTypeHeader) => {
    switch (contentTypeHeader) {
        case 'application/json':
            return jsonParser;
        case 'application/x-www-form-urlencoded':
            return urlencodedParser;
        default:
            return jsonParser;
    }
};
function parseRequestOptions(options) {
    if (!options) {
        return {};
    }
    const headers = options.headers ?? {};
    const contentTypeHeader = headers['Content-Type'] || headers['content-type'];
    return getParser(contentTypeHeader?.toLowerCase())(options);
}
//# sourceMappingURL=parsers.js.map