import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const UsersListStatusParamsGetSchema = {
    type: 'object',
    properties: {
        status: {
            type: 'string',
            enum: ['active', 'deactivated'],
        },
        hasLoggedIn: {
            type: 'boolean',
            nullable: true,
        },
        type: {
            type: 'string',
            nullable: true,
        },
        roles: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        searchTerm: {
            type: 'string',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isUsersListStatusProps = ajv.compile(UsersListStatusParamsGetSchema);
//# sourceMappingURL=UsersListStatusParamsGET.js.map