import { ILivechatAgentStatus } from '@rocket.chat/core-typings';
import { ajv } from './Ajv';
const LivechatVisitorsInfoSchema = {
    type: 'object',
    properties: {
        visitorId: {
            type: 'string',
        },
    },
    required: ['visitorId'],
    additionalProperties: false,
};
export const isLivechatVisitorsInfoProps = ajv.compile(LivechatVisitorsInfoSchema);
const LivechatRoomOnHoldSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isLivechatRoomOnHoldProps = ajv.compile(LivechatRoomOnHoldSchema);
const LivechatRoomResumeOnHoldSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isLivechatRoomResumeOnHoldProps = ajv.compile(LivechatRoomResumeOnHoldSchema);
const LivechatDepartmentIdSchema = {
    type: 'object',
    properties: {
        onlyMyDepartments: {
            type: 'string',
            nullable: true,
        },
        includeAgents: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isLivechatDepartmentIdProps = ajv.compile(LivechatDepartmentIdSchema);
const LivechatDepartmentAutocompleteSchema = {
    type: 'object',
    properties: {
        selector: {
            type: 'string',
        },
        onlyMyDepartments: {
            type: 'string',
        },
        showArchived: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['selector', 'onlyMyDepartments'],
    additionalProperties: false,
};
export const isLivechatDepartmentAutocompleteProps = ajv.compile(LivechatDepartmentAutocompleteSchema);
const LivechatDepartmentDepartmentIdAgentsGETSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: [],
    additionalProperties: false,
};
export const isLivechatDepartmentDepartmentIdAgentsGETProps = ajv.compile(LivechatDepartmentDepartmentIdAgentsGETSchema);
const LivechatDepartmentDepartmentIdAgentsPOSTSchema = {
    type: 'object',
    properties: {
        upsert: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    agentId: {
                        type: 'string',
                    },
                    username: {
                        type: 'string',
                    },
                    name: { type: 'string' },
                    count: {
                        type: 'number',
                    },
                    order: {
                        type: 'number',
                    },
                },
                required: ['agentId', 'username'],
                additionalProperties: false,
            },
        },
        remove: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    agentId: {
                        type: 'string',
                    },
                    username: {
                        type: 'string',
                    },
                    name: {
                        type: 'string',
                    },
                    count: {
                        type: 'number',
                    },
                    order: {
                        type: 'number',
                    },
                    departmentEnabled: { type: 'boolean' },
                    departmentId: { type: 'string' },
                    _id: { type: 'string' },
                    _updatedAt: { type: 'string' },
                },
                required: ['agentId', 'username'],
                additionalProperties: false,
            },
        },
    },
    required: ['upsert', 'remove'],
    additionalProperties: false,
};
export const isLivechatDepartmentDepartmentIdAgentsPOSTProps = ajv.compile(LivechatDepartmentDepartmentIdAgentsPOSTSchema);
const LivechatVisitorTokenGetSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isLivechatVisitorTokenGetProps = ajv.compile(LivechatVisitorTokenGetSchema);
const LivechatVisitorTokenDeleteSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isLivechatVisitorTokenDeleteProps = ajv.compile(LivechatVisitorTokenDeleteSchema);
const LivechatVisitorTokenRoomSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isLivechatVisitorTokenRoomProps = ajv.compile(LivechatVisitorTokenRoomSchema);
const LivechatVisitorCallStatusSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        callStatus: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        callId: {
            type: 'string',
        },
    },
    required: ['token', 'callStatus', 'rid', 'callId'],
    additionalProperties: false,
};
export const isLivechatVisitorCallStatusProps = ajv.compile(LivechatVisitorCallStatusSchema);
const LivechatVisitorStatusSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        status: {
            type: 'string',
        },
    },
    required: ['token', 'status'],
    additionalProperties: false,
};
export const isLivechatVisitorStatusProps = ajv.compile(LivechatVisitorStatusSchema);
const LiveChatRoomJoinSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isLiveChatRoomJoinProps = ajv.compile(LiveChatRoomJoinSchema);
const LiveChatRoomForwardSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        userId: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        comment: {
            type: 'string',
            nullable: true,
        },
        clientAction: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isLiveChatRoomForwardProps = ajv.compile(LiveChatRoomForwardSchema);
const LiveChatRoomSaveInfoSchema = {
    type: 'object',
    properties: {
        guestData: {
            type: 'object',
            properties: {
                _id: {
                    type: 'string',
                },
                name: {
                    type: 'string',
                    nullable: true,
                },
                email: {
                    type: 'string',
                    nullable: true,
                },
                phone: {
                    type: 'string',
                    nullable: true,
                },
                livechatData: {
                    type: 'object',
                    patternProperties: {
                        '.*': {
                            type: 'string',
                        },
                    },
                    nullable: true,
                },
            },
            required: ['_id'],
            additionalProperties: false,
        },
        roomData: {
            type: 'object',
            properties: {
                _id: {
                    type: 'string',
                },
                topic: {
                    type: 'string',
                    nullable: true,
                },
                tags: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                livechatData: {
                    type: 'object',
                    nullable: true,
                },
                priorityId: {
                    type: 'string',
                    nullable: true,
                },
                slaId: {
                    type: 'string',
                    nullable: true,
                },
            },
            required: ['_id'],
            additionalProperties: false,
        },
    },
    required: ['guestData', 'roomData'],
    additionalProperties: false,
};
export const isLiveChatRoomSaveInfoProps = ajv.compile(LiveChatRoomSaveInfoSchema);
const LivechatMonitorsListSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['text'],
    additionalProperties: false,
};
export const isLivechatMonitorsListProps = ajv.compile(LivechatMonitorsListSchema);
const POSTLivechatTagsRemoveSchema = {
    type: 'object',
    properties: {
        id: {
            type: 'string',
        },
    },
    required: ['id'],
    additionalProperties: false,
};
export const isPOSTLivechatTagsRemoveParams = ajv.compile(POSTLivechatTagsRemoveSchema);
const POSTLivechatTagsRemoveSuccessResponseSchema = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTLivechatTagsRemoveSuccessResponse = ajv.compile(POSTLivechatTagsRemoveSuccessResponseSchema);
const LivechatTagsListSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
        },
        department: {
            type: 'string',
            nullable: true,
        },
        viewAll: {
            type: 'string',
            nullable: true,
            enum: ['true', 'false'],
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['text'],
    additionalProperties: false,
};
export const isLivechatTagsListProps = ajv.compile(LivechatTagsListSchema);
const LivechatDepartmentSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        onlyMyDepartments: {
            type: 'string',
            enum: ['true', 'false'],
            nullable: true,
        },
        enabled: {
            type: 'string',
            nullable: true,
        },
        excludeDepartmentId: {
            type: 'string',
            nullable: true,
        },
        showArchived: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatDepartmentProps = ajv.compile(LivechatDepartmentSchema);
const POSTLivechatDepartmentSchema = {
    type: 'object',
    properties: {
        department: {
            type: 'object',
            properties: {
                enabled: {
                    type: 'boolean',
                },
                name: {
                    type: 'string',
                },
                description: {
                    type: 'string',
                    nullable: true,
                },
                showOnRegistration: {
                    type: 'boolean',
                },
                showOnOfflineForm: {
                    type: 'boolean',
                },
                requestTagBeforeClosingChat: {
                    type: 'boolean',
                    nullable: true,
                },
                chatClosingTags: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                fallbackForwardDepartment: {
                    type: 'string',
                    nullable: true,
                },
                email: {
                    type: 'string',
                },
                departmentsAllowedToForward: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                allowReceiveForwardOffline: {
                    type: 'boolean',
                    nullable: true,
                },
                offlineMessageChannelName: {
                    type: 'string',
                    nullable: true,
                },
                abandonedRoomsCloseCustomMessage: {
                    type: 'string',
                    nullable: true,
                },
                waitingQueueMessage: {
                    type: 'string',
                    nullable: true,
                },
            },
            required: ['name', 'email', 'enabled', 'showOnRegistration', 'showOnOfflineForm'],
            additionalProperties: true,
        },
        agents: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    agentId: {
                        type: 'string',
                    },
                    count: {
                        type: 'number',
                        nullable: true,
                    },
                    order: {
                        type: 'number',
                        nullable: true,
                    },
                },
                required: ['agentId'],
                additionalProperties: false,
            },
            nullable: true,
        },
        departmentUnit: {
            type: 'object',
            properties: {
                _id: {
                    type: 'string',
                },
            },
            additionalProperties: false,
        },
    },
    required: ['department'],
    additionalProperties: false,
};
export const isPOSTLivechatDepartmentProps = ajv.compile(POSTLivechatDepartmentSchema);
const LivechatDepartmentsAvailableByUnitIdSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
        },
        onlyMyDepartments: {
            type: 'string',
            enum: ['true', 'false'],
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['text'],
    additionalProperties: false,
};
export const isLivechatDepartmentsAvailableByUnitIdProps = ajv.compile(LivechatDepartmentsAvailableByUnitIdSchema);
const LivechatDepartmentsByUnitSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['text'],
    additionalProperties: false,
};
export const isLivechatDepartmentsByUnitProps = ajv.compile(LivechatDepartmentsByUnitSchema);
const LivechatDepartmentsByUnitIdSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['text'],
    additionalProperties: false,
};
export const isLivechatDepartmentsByUnitIdProps = ajv.compile(LivechatDepartmentsByUnitIdSchema);
const LivechatUsersManagerGETSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        onlyAvailable: {
            type: 'boolean',
            nullable: true,
        },
        excludeId: {
            type: 'string',
            nullable: true,
        },
        showIdleAgents: {
            type: 'boolean',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
        fields: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isLivechatUsersManagerGETProps = ajv.compile(LivechatUsersManagerGETSchema);
const LivechatUsersManagerPOSTSchema = {
    type: 'object',
    properties: {
        username: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['username'],
    additionalProperties: false,
};
export const isLivechatUsersManagerPOSTProps = ajv.compile(LivechatUsersManagerPOSTSchema);
const LivechatQueuePropsSchema = {
    type: 'object',
    properties: {
        agentId: {
            type: 'string',
            nullable: true,
        },
        includeOfflineAgents: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['count', 'offset', 'sort'],
    additionalProperties: false,
};
export const isLivechatQueueProps = ajv.compile(LivechatQueuePropsSchema);
const CannedResponsesPropsSchema = {
    type: 'object',
    properties: {
        scope: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        shortcut: {
            type: 'string',
            nullable: true,
        },
        tags: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        createdBy: {
            type: 'string',
            nullable: true,
        },
        text: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isCannedResponsesProps = ajv.compile(CannedResponsesPropsSchema);
const LivechatCustomFieldsSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isLivechatCustomFieldsProps = ajv.compile(LivechatCustomFieldsSchema);
const LivechatRoomsSchema = {
    type: 'object',
    properties: {
        guest: {
            type: 'string',
        },
        fname: {
            type: 'string',
        },
        servedBy: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
        status: {
            type: 'string',
        },
        department: {
            type: 'string',
        },
        from: {
            type: 'string',
        },
        to: {
            type: 'string',
        },
        customFields: {
            type: 'object',
            nullable: true,
        },
        current: {
            type: 'number',
        },
        itemsPerPage: {
            type: 'number',
        },
        tags: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
    },
    required: ['guest', 'fname', 'servedBy', 'status', 'department', 'from', 'to', 'current', 'itemsPerPage'],
    additionalProperties: false,
};
export const isLivechatRoomsProps = ajv.compile(LivechatRoomsSchema);
const LivechatRidMessagesSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        searchTerm: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isLivechatRidMessagesProps = ajv.compile(LivechatRidMessagesSchema);
const LivechatUsersAgentSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isLivechatUsersAgentProps = ajv.compile(LivechatUsersAgentSchema);
const LivechatPrioritiesPropsSchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
        fields: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isLivechatPrioritiesProps = ajv.compile(LivechatPrioritiesPropsSchema);
const CreateOrUpdateLivechatSlaPropsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        description: {
            type: 'string',
            nullable: true,
        },
        dueTimeInMinutes: {
            type: 'number',
        },
    },
    required: ['name', 'dueTimeInMinutes'],
    additionalProperties: false,
};
export const isCreateOrUpdateLivechatSlaProps = ajv.compile(CreateOrUpdateLivechatSlaPropsSchema);
const POSTOmnichannelContactSchema = {
    type: 'object',
    properties: {
        _id: {
            type: 'string',
            nullable: true,
        },
        token: {
            type: 'string',
        },
        name: {
            type: 'string',
        },
        username: {
            type: 'string',
        },
        email: {
            type: 'string',
            nullable: true,
        },
        phone: {
            type: 'string',
            nullable: true,
        },
        customFields: {
            type: 'object',
            nullable: true,
        },
        contactManager: {
            type: 'object',
            nullable: true,
            properties: {
                username: {
                    type: 'string',
                },
            },
        },
    },
    required: ['token', 'name', 'username'],
    additionalProperties: false,
};
export const isPOSTOmnichannelContactProps = ajv.compile(POSTOmnichannelContactSchema);
const POSTOmnichannelContactsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        emails: {
            type: 'array',
            items: {
                type: 'string',
            },
            uniqueItems: true,
        },
        phones: {
            type: 'array',
            items: {
                type: 'string',
            },
            uniqueItems: true,
        },
        customFields: {
            type: 'object',
            nullable: true,
        },
        contactManager: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['name', 'emails', 'phones'],
    additionalProperties: false,
};
export const isPOSTOmnichannelContactsProps = ajv.compile(POSTOmnichannelContactsSchema);
const POSTUpdateOmnichannelContactsSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
        name: {
            type: 'string',
        },
        emails: {
            type: 'array',
            items: {
                type: 'string',
            },
            uniqueItems: true,
            nullable: true,
        },
        phones: {
            type: 'array',
            items: {
                type: 'string',
            },
            uniqueItems: true,
            nullable: true,
        },
        customFields: {
            type: 'object',
            nullable: true,
        },
        contactManager: {
            type: 'string',
            nullable: true,
        },
        wipeConflicts: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isPOSTUpdateOmnichannelContactsProps = ajv.compile(POSTUpdateOmnichannelContactsSchema);
const POSTOmnichannelContactDeleteSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isPOSTOmnichannelContactDeleteProps = ajv.compile(POSTOmnichannelContactDeleteSchema);
const POSTOmnichannelContactDeleteSuccess = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTOmnichannelContactDeleteSuccessSchema = ajv.compile(POSTOmnichannelContactDeleteSuccess);
const POSTOmnichannelContactsConflictsSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
        name: {
            type: 'string',
            nullable: true,
        },
        contactManager: {
            type: 'string',
            nullable: true,
        },
        customFields: {
            type: 'object',
        },
        wipeConflicts: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isPOSTOmnichannelContactsConflictsProps = ajv.compile(POSTOmnichannelContactsConflictsSchema);
export const ContactVisitorAssociationSchema = {
    type: 'object',
    properties: {
        visitorId: {
            type: 'string',
        },
        source: {
            type: 'object',
            properties: {
                type: {
                    type: 'string',
                },
                id: {
                    type: 'string',
                },
            },
            required: ['type'],
        },
    },
    nullable: false,
    required: ['visitorId', 'source'],
};
const GETOmnichannelContactsSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
            nullable: false,
            isNotEmpty: true,
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isGETOmnichannelContactsProps = ajv.compile(GETOmnichannelContactsSchema);
const GETOmnichannelContactsSearchSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
        searchText: {
            type: 'string',
        },
        unknown: {
            type: 'boolean',
        },
    },
    required: [],
    additionalProperties: false,
};
export const isGETOmnichannelContactsSearchProps = ajv.compile(GETOmnichannelContactsSearchSchema);
const GETOmnichannelContactsCheckExistenceSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                contactId: {
                    type: 'string',
                    nullable: false,
                    isNotEmpty: true,
                },
            },
            required: ['contactId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                email: {
                    type: 'string',
                    format: 'basic_email',
                    nullable: false,
                    isNotEmpty: true,
                },
            },
            required: ['email'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                phone: {
                    type: 'string',
                    nullable: false,
                    isNotEmpty: true,
                },
            },
            required: ['phone'],
            additionalProperties: false,
        },
    ],
};
export const isGETOmnichannelContactsCheckExistenceProps = ajv.compile(GETOmnichannelContactsCheckExistenceSchema);
const GETOmnichannelContactHistorySchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
        source: {
            type: 'string',
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isGETOmnichannelContactHistoryProps = ajv.compile(GETOmnichannelContactHistorySchema);
const GETOmnichannelContactsChannelsSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isGETOmnichannelContactsChannelsProps = ajv.compile(GETOmnichannelContactsChannelsSchema);
const GETOmnichannelContactSchema = {
    type: 'object',
    properties: {
        contactId: {
            type: 'string',
        },
    },
    required: ['contactId'],
    additionalProperties: false,
};
export const isGETOmnichannelContactProps = ajv.compile(GETOmnichannelContactSchema);
const LivechatAnalyticsAgentsAverageServiceTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsAgentsAverageServiceTimeProps = ajv.compile(LivechatAnalyticsAgentsAverageServiceTimeSchema);
const GETOmnichannelContactSearchSchema = {
    anyOf: [
        {
            type: 'object',
            properties: {
                email: {
                    type: 'string',
                },
            },
            required: ['email'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                phone: {
                    type: 'string',
                },
            },
            required: ['phone'],
            additionalProperties: false,
        },
    ],
};
export const isGETOmnichannelContactSearchProps = ajv.compile(GETOmnichannelContactSearchSchema);
const POSTLivechatAgentStatusPropsSchema = {
    type: 'object',
    properties: {
        status: {
            type: 'string',
            enum: Object.values(ILivechatAgentStatus),
            nullable: true,
        },
        agentId: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isPOSTLivechatAgentStatusProps = ajv.compile(POSTLivechatAgentStatusPropsSchema);
const POSTLivechatAgentSaveInfoParamsSchema = {
    type: 'object',
    properties: {
        agentId: {
            type: 'string',
        },
        agentData: {
            type: 'object',
            additionalProperties: true,
        },
        agentDepartments: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
    },
    required: ['agentId', 'agentData', 'agentDepartments'],
    additionalProperties: false,
};
export const isPOSTLivechatAgentSaveInfoParams = ajv.compile(POSTLivechatAgentSaveInfoParamsSchema);
const POSTLivechatAgentSaveInfoSuccessResponseSchema = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTLivechatAgentSaveInfoSuccessResponse = ajv.compile(POSTLivechatAgentSaveInfoSuccessResponseSchema);
const LivechatAnalyticsAgentsTotalServiceTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsAgentsTotalServiceTimeProps = ajv.compile(LivechatAnalyticsAgentsTotalServiceTimeSchema);
const LivechatAnalyticsAgentsAvailableForServiceHistorySchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        fullReport: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsAgentsAvailableForServiceHistoryProps = ajv.compile(LivechatAnalyticsAgentsAvailableForServiceHistorySchema);
const LivechatAnalyticsDepartmentsAmountOfChatsSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        answered: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsAmountOfChatsProps = ajv.compile(LivechatAnalyticsDepartmentsAmountOfChatsSchema);
const LivechatAnalyticsDepartmentsAverageServiceTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsAverageServiceTimeProps = ajv.compile(LivechatAnalyticsDepartmentsAverageServiceTimeSchema);
const LivechatAnalyticsDepartmentsAverageChatDurationTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsAverageChatDurationTimeProps = ajv.compile(LivechatAnalyticsDepartmentsAverageChatDurationTimeSchema);
const LivechatAnalyticsDepartmentsTotalServiceTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsTotalServiceTimeProps = ajv.compile(LivechatAnalyticsDepartmentsTotalServiceTimeSchema);
const LivechatAnalyticsDepartmentsAverageWaitingTimeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsAverageWaitingTimeProps = ajv.compile(LivechatAnalyticsDepartmentsAverageWaitingTimeSchema);
const LivechatAnalyticsDepartmentsTotalTransferredChatsSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsTotalTransferredChatsProps = ajv.compile(LivechatAnalyticsDepartmentsTotalTransferredChatsSchema);
const LivechatAnalyticsDepartmentsTotalAbandonedChatsSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsTotalAbandonedChatsProps = ajv.compile(LivechatAnalyticsDepartmentsTotalAbandonedChatsSchema);
const LivechatAnalyticsDepartmentsPercentageAbandonedChatsSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
        },
        offset: {
            type: 'number',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isLivechatAnalyticsDepartmentsPercentageAbandonedChatsProps = ajv.compile(LivechatAnalyticsDepartmentsPercentageAbandonedChatsSchema);
const GETAgentNextTokenSchema = {
    type: 'object',
    properties: {
        department: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETAgentNextToken = ajv.compile(GETAgentNextTokenSchema);
const GETLivechatConfigParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
            nullable: true,
        },
        department: {
            type: 'string',
            nullable: true,
        },
        businessUnit: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatConfigParams = ajv.compile(GETLivechatConfigParamsSchema);
export const GETLivechatConfigRoutingSchema = {
    type: 'object',
    properties: {
        config: {
            type: 'object',
            nullable: true,
            properties: {
                previewRoom: {
                    type: 'boolean',
                },
                showConnecting: {
                    type: 'boolean',
                },
                showQueue: {
                    type: 'boolean',
                },
                showQueueLink: {
                    type: 'boolean',
                },
                returnQueue: {
                    type: 'boolean',
                },
                enableTriggerAction: {
                    type: 'boolean',
                },
                autoAssignAgent: {
                    type: 'boolean',
                },
            },
        },
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const GETLivechatConfigRouting = ajv.compile(GETLivechatConfigRoutingSchema);
const POSTLivechatCustomFieldParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        key: {
            type: 'string',
        },
        value: {
            type: 'string',
        },
        overwrite: {
            type: 'boolean',
        },
    },
    required: ['token', 'key', 'value', 'overwrite'],
    additionalProperties: false,
};
export const isPOSTLivechatCustomFieldParams = ajv.compile(POSTLivechatCustomFieldParamsSchema);
const POSTLivechatCustomFieldsParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        customFields: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    key: {
                        type: 'string',
                    },
                    value: {
                        type: 'string',
                    },
                    overwrite: {
                        type: 'boolean',
                    },
                },
                required: ['key', 'value', 'overwrite'],
                additionalProperties: false,
            },
        },
    },
    required: ['token', 'customFields'],
    additionalProperties: false,
};
export const isPOSTLivechatCustomFieldsParams = ajv.compile(POSTLivechatCustomFieldsParamsSchema);
const GETWebRTCCallSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isGETWebRTCCall = ajv.compile(GETWebRTCCallSchema);
const PUTWebRTCCallIdSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        status: {
            type: 'string',
        },
    },
    required: ['rid', 'status'],
    additionalProperties: false,
};
export const isPUTWebRTCCallId = ajv.compile(PUTWebRTCCallIdSchema);
const POSTLivechatTranscriptParamsSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        token: {
            type: 'string',
        },
        email: {
            type: 'string',
        },
        subject: {
            type: 'string',
        },
    },
    required: ['rid', 'token', 'email'],
    additionalProperties: false,
};
export const isPOSTLivechatTranscriptParams = ajv.compile(POSTLivechatTranscriptParamsSchema);
const POSTLivechatOfflineMessageParamsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        email: {
            type: 'string',
        },
        message: {
            type: 'string',
        },
        department: {
            type: 'string',
            nullable: true,
        },
        host: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['name', 'email', 'message'],
    additionalProperties: false,
};
export const isPOSTLivechatOfflineMessageParams = ajv.compile(POSTLivechatOfflineMessageParamsSchema);
const POSTLivechatPageVisitedParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
            nullable: true,
        },
        pageInfo: {
            type: 'object',
            properties: {
                title: {
                    type: 'string',
                },
                change: {
                    type: 'string',
                },
                location: {
                    type: 'object',
                    properties: {
                        href: {
                            type: 'string',
                        },
                    },
                    required: ['href'],
                    additionalProperties: false,
                },
            },
            required: ['title', 'change', 'location'],
            additionalProperties: false,
        },
    },
    required: ['token', 'pageInfo'],
    additionalProperties: false,
};
export const isPOSTLivechatPageVisitedParams = ajv.compile(POSTLivechatPageVisitedParamsSchema);
const POSTLivechatMessageParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        msg: {
            type: 'string',
        },
        _id: {
            type: 'string',
            nullable: true,
        },
        agent: {
            type: 'object',
            properties: {
                agentId: {
                    type: 'string',
                },
                username: {
                    type: 'string',
                },
            },
            required: ['agentId', 'username'],
            additionalProperties: false,
        },
    },
    required: ['token', 'rid', 'msg'],
    additionalProperties: false,
};
export const isPOSTLivechatMessageParams = ajv.compile(POSTLivechatMessageParamsSchema);
const GETLivechatMessageIdParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
    },
    required: ['token', 'rid'],
    additionalProperties: false,
};
export const isGETLivechatMessageIdParams = ajv.compile(GETLivechatMessageIdParamsSchema);
const PUTLivechatMessageIdParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        msg: {
            type: 'string',
        },
    },
    required: ['token', 'rid', 'msg'],
    additionalProperties: false,
};
export const isPUTLivechatMessageIdParams = ajv.compile(PUTLivechatMessageIdParamsSchema);
const DELETELivechatMessageIdParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['token', 'rid'],
    additionalProperties: false,
};
export const isDELETELivechatMessageIdParams = ajv.compile(DELETELivechatMessageIdParamsSchema);
const GETLivechatMessagesHistoryRidParamsSchema = {
    type: 'object',
    properties: {
        searchText: {
            type: 'string',
            nullable: true,
        },
        token: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        ls: {
            type: 'string',
            nullable: true,
        },
        end: {
            type: 'string',
            nullable: true,
        },
        limit: {
            type: 'number',
            nullable: true,
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isGETLivechatMessagesHistoryRidParams = ajv.compile(GETLivechatMessagesHistoryRidParamsSchema);
const GETLivechatMessagesParamsSchema = {
    type: 'object',
    properties: {
        visitor: {
            type: 'object',
            properties: {
                token: {
                    type: 'string',
                },
            },
            required: ['token'],
            additionalProperties: false,
        },
        messages: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    msg: {
                        type: 'string',
                    },
                },
                required: ['msg'],
                additionalProperties: false,
            },
            minItems: 1,
        },
    },
    required: ['visitor', 'messages'],
    additionalProperties: false,
};
export const isGETLivechatMessagesParams = ajv.compile(GETLivechatMessagesParamsSchema);
const GETLivechatRoomParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
            nullable: true,
        },
        agentId: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['token'],
    additionalProperties: true,
};
export const isGETLivechatRoomParams = ajv.compile(GETLivechatRoomParamsSchema);
const POSTLivechatRoomCloseParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
    },
    required: ['token', 'rid'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomCloseParams = ajv.compile(POSTLivechatRoomCloseParamsSchema);
const POSTLivechatRoomCloseByUserParamsSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        comment: {
            type: 'string',
            nullable: true,
        },
        tags: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        generateTranscriptPdf: {
            type: 'boolean',
            nullable: true,
        },
        transcriptEmail: {
            type: 'object',
            properties: {
                sendToVisitor: {
                    type: 'boolean',
                },
                requestData: {
                    type: 'object',
                    properties: {
                        email: {
                            type: 'string',
                        },
                        subject: {
                            type: 'string',
                        },
                    },
                    required: ['email', 'subject'],
                    additionalProperties: false,
                },
            },
            required: ['sendToVisitor'],
            additionalProperties: false,
        },
        forceClose: {
            type: 'boolean',
        },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomCloseByUserParams = ajv.compile(POSTLivechatRoomCloseByUserParamsSchema);
const POSTLivechatRoomTransferParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        department: {
            type: 'string',
        },
    },
    required: ['token', 'rid', 'department'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomTransferParams = ajv.compile(POSTLivechatRoomTransferParamsSchema);
const POSTLivechatRoomSurveyParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        data: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    name: {
                        type: 'string',
                    },
                    value: {
                        type: 'string',
                    },
                },
                required: ['name', 'value'],
                additionalProperties: false,
            },
            minItems: 1,
        },
    },
    required: ['token', 'rid', 'data'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomSurveyParams = ajv.compile(POSTLivechatRoomSurveyParamsSchema);
const POSTCannedResponsesPropsSchema = {
    type: 'object',
    properties: {
        _id: {
            type: 'string',
            nullable: true,
        },
        shortcut: {
            type: 'string',
        },
        text: {
            type: 'string',
        },
        scope: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        tags: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
    },
    required: ['shortcut', 'text', 'scope'],
    additionalProperties: false,
};
export const isPOSTCannedResponsesProps = ajv.compile(POSTCannedResponsesPropsSchema);
const DELETECannedResponsesPropsSchema = {
    type: 'object',
    properties: {
        _id: {
            type: 'string',
        },
    },
    required: ['_id'],
    additionalProperties: false,
};
export const isDELETECannedResponsesProps = ajv.compile(DELETECannedResponsesPropsSchema);
const POSTLivechatUsersTypePropsSchema = {
    type: 'object',
    properties: {
        username: {
            type: 'string',
        },
    },
    required: ['username'],
    additionalProperties: false,
};
export const isPOSTLivechatUsersTypeProps = ajv.compile(POSTLivechatUsersTypePropsSchema);
const GETLivechatVisitorsPagesVisitedRoomIdParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatVisitorsPagesVisitedRoomIdParams = ajv.compile(GETLivechatVisitorsPagesVisitedRoomIdParamsSchema);
const GETLivechatVisitorsChatHistoryRoomRoomIdVisitorVisitorIdParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatVisitorsChatHistoryRoomRoomIdVisitorVisitorIdParams = ajv.compile(GETLivechatVisitorsChatHistoryRoomRoomIdVisitorVisitorIdParamsSchema);
const GETLivechatVisitorsSearchChatsRoomRoomIdVisitorVisitorIdParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        searchText: {
            type: 'string',
            nullable: true,
        },
        closedChatsOnly: {
            type: 'string',
            nullable: true,
        },
        servedChatsOnly: {
            type: 'string',
            nullable: true,
        },
        source: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatVisitorsSearchChatsRoomRoomIdVisitorVisitorIdParams = ajv.compile(GETLivechatVisitorsSearchChatsRoomRoomIdVisitorVisitorIdParamsSchema);
const GETLivechatVisitorsAutocompleteParamsSchema = {
    type: 'object',
    properties: {
        selector: {
            type: 'string',
        },
    },
    required: ['selector'],
    additionalProperties: false,
};
export const isGETLivechatVisitorsAutocompleteParams = ajv.compile(GETLivechatVisitorsAutocompleteParamsSchema);
const GETLivechatVisitorsSearchSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        term: {
            type: 'string',
        },
    },
    required: ['term'],
    additionalProperties: false,
};
export const isGETLivechatVisitorsSearch = ajv.compile(GETLivechatVisitorsSearchSchema);
const GETLivechatAgentsAgentIdDepartmentsParamsSchema = {
    type: 'object',
    properties: {
        enabledDepartmentsOnly: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatAgentsAgentIdDepartmentsParams = ajv.compile(GETLivechatAgentsAgentIdDepartmentsParamsSchema);
const GETBusinessHourParamsSchema = {
    type: 'object',
    properties: {
        _id: {
            type: 'string',
            nullable: true,
        },
        type: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETBusinessHourParams = ajv.compile(GETBusinessHourParamsSchema);
const GETLivechatTriggersParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatTriggersParams = ajv.compile(GETLivechatTriggersParamsSchema);
const GETLivechatRoomsParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
        fields: {
            type: 'string',
            nullable: true,
        },
        createdAt: {
            type: 'string',
            nullable: true,
        },
        customFields: {
            type: 'string',
            nullable: true,
        },
        closedAt: {
            type: 'string',
            nullable: true,
        },
        agents: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        roomName: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            oneOf: [{ type: 'string' }, { type: 'array', items: { type: 'string' } }],
        },
        open: {
            anyOf: [
                { type: 'string', nullable: true },
                { type: 'boolean', nullable: true },
            ],
        },
        onhold: {
            anyOf: [
                { type: 'string', nullable: true },
                { type: 'boolean', nullable: true },
            ],
        },
        queued: {
            anyOf: [
                { type: 'string', nullable: true },
                { type: 'boolean', nullable: true },
            ],
        },
        tags: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        units: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
    },
    additionalProperties: false,
};
export const isGETLivechatRoomsParams = ajv.compile(GETLivechatRoomsParamsSchema);
const POSTLivechatRoomPriorityParamsSchema = {
    type: 'object',
    properties: {
        priorityId: {
            type: 'string',
        },
    },
    required: ['priorityId'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomPriorityParams = ajv.compile(POSTLivechatRoomPriorityParamsSchema);
const GETLivechatQueueParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        agentId: {
            type: 'string',
            nullable: true,
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
        includeOfflineAgents: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatQueueParams = ajv.compile(GETLivechatQueueParamsSchema);
const GETLivechatPrioritiesParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        text: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isGETLivechatPrioritiesParams = ajv.compile(GETLivechatPrioritiesParamsSchema);
const DELETELivechatPriorityParamsSchema = {
    type: 'object',
    properties: {
        priorityId: {
            type: 'string',
        },
    },
    required: ['priorityId'],
    additionalProperties: false,
};
export const isDELETELivechatPriorityParams = ajv.compile(DELETELivechatPriorityParamsSchema);
const POSTLivechatPriorityParamsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
            nullable: false,
        },
        level: {
            type: 'string',
            nullable: false,
        },
    },
    required: ['name', 'level'],
    additionalProperties: false,
};
export const isPOSTLivechatPriorityParams = ajv.compile(POSTLivechatPriorityParamsSchema);
const GETLivechatInquiriesListParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        department: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatInquiriesListParams = ajv.compile(GETLivechatInquiriesListParamsSchema);
const POSTLivechatInquiriesTakeParamsSchema = {
    type: 'object',
    properties: {
        inquiryId: {
            type: 'string',
        },
        userId: {
            type: 'string',
            nullable: true,
        },
        options: {
            type: 'object',
            nullable: true,
            properties: {
                clientAction: {
                    type: 'boolean',
                },
                forwardingToDepartment: {
                    type: 'object',
                    nullable: true,
                    properties: {
                        oldDepartmentId: {
                            type: 'string',
                        },
                        transferData: {
                            type: 'object',
                        },
                    },
                    required: ['oldDepartmentId', 'transferData'],
                    additionalProperties: false,
                },
            },
            required: ['clientAction'],
            additionalProperties: false,
        },
    },
    additionalProperties: false,
    required: ['inquiryId'],
};
export const isPOSTLivechatInquiriesTakeParams = ajv.compile(POSTLivechatInquiriesTakeParamsSchema);
const GETLivechatInquiriesQueuedForUserParamsSchema = {
    type: 'object',
    properties: {
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        department: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
};
export const isGETLivechatInquiriesQueuedForUserParams = ajv.compile(GETLivechatInquiriesQueuedForUserParamsSchema);
const GETLivechatInquiriesGetOneParamsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    additionalProperties: false,
    required: ['roomId'],
};
export const isGETLivechatInquiriesGetOneParams = ajv.compile(GETLivechatInquiriesGetOneParamsSchema);
const POSTLivechatInquiriesReturnAsInquirySchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isPOSTLivechatInquiriesReturnAsInquiry = ajv.compile(POSTLivechatInquiriesReturnAsInquirySchema);
const POSTLivechatInquiriesReturnAsInquirySuccessResponseSchema = {
    type: 'object',
    properties: {
        result: {
            type: 'boolean',
        },
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTLivechatInquiriesReturnAsInquirySuccessResponse = ajv.compile(POSTLivechatInquiriesReturnAsInquirySuccessResponseSchema);
const GETLivechatAnalyticsDashboardsConversationTotalizersParamsSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
    },
    additionalProperties: false,
    required: ['start', 'end'],
};
export const isGETDashboardTotalizerParams = ajv.compile(GETLivechatAnalyticsDashboardsConversationTotalizersParamsSchema);
const GETLivechatAnalyticsDashboardsAgentStatusParamsSchema = {
    type: 'object',
    properties: {
        departmentId: {
            type: 'string',
            nullable: true,
        },
    },
    // FE is sending start/end params, since they use the same container for doing all calls.
    // This will prevent FE breaking, but's a TODO for an upcoming engday
    additionalProperties: true,
};
export const isGETDashboardsAgentStatusParams = ajv.compile(GETLivechatAnalyticsDashboardsAgentStatusParamsSchema);
const GETLivechatAnalyticsDashboardsChartDataParamsSchema = {
    type: 'object',
    properties: {
        chartName: {
            type: 'string',
        },
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
        },
    },
    additionalProperties: false,
    required: ['chartName', 'start', 'end'],
};
export const isGETLivechatAnalyticsDashboardsChartDataParams = ajv.compile(GETLivechatAnalyticsDashboardsChartDataParamsSchema);
const GETLivechatAnalyticsDashboardsChartDataSuccess = {
    type: 'object',
    properties: {
        chartLabel: {
            type: 'string',
        },
        dataLabels: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
        dataPoints: {
            type: 'array',
            items: {
                type: 'number',
            },
        },
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const GETLivechatAnalyticsDashboardsChartDataSuccessSchema = ajv.compile(GETLivechatAnalyticsDashboardsChartDataSuccess);
const PUTLivechatPrioritySchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                name: {
                    type: 'string',
                },
                required: true,
            },
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                reset: {
                    type: 'boolean',
                },
                required: true,
            },
            additionalProperties: false,
        },
    ],
};
export const isPUTLivechatPriority = ajv.compile(PUTLivechatPrioritySchema);
const POSTomnichannelIntegrationsSchema = {
    type: 'object',
    properties: {
        LivechatWebhookUrl: {
            type: 'string',
            nullable: true,
        },
        LivechatSecretToken: {
            type: 'string',
            nullable: true,
        },
        LivechatHttpTimeout: {
            type: 'number',
            nullable: true,
        },
        LivechatWebhookOnStart: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnClose: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnChatTaken: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnChatQueued: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnForward: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnOfflineMsg: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnVisitorMessage: {
            type: 'boolean',
            nullable: true,
        },
        LivechatWebhookOnAgentMessage: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isPOSTomnichannelIntegrations = ajv.compile(POSTomnichannelIntegrationsSchema);
const POSTLivechatTranscriptRequestParamsSchema = {
    type: 'object',
    properties: {
        email: {
            type: 'string',
        },
        subject: {
            type: 'string',
        },
    },
    required: ['email', 'subject'],
    additionalProperties: false,
};
export const isPOSTLivechatTranscriptRequestParams = ajv.compile(POSTLivechatTranscriptRequestParamsSchema);
const POSTLivechatTriggersParamsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        description: {
            type: 'string',
        },
        enabled: {
            type: 'boolean',
        },
        runOnce: {
            type: 'boolean',
        },
        conditions: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    name: {
                        type: 'string',
                        enum: ['time-on-site', 'page-url', 'chat-opened-by-visitor', 'after-guest-registration'],
                    },
                    value: {
                        type: 'string',
                        nullable: true,
                    },
                },
                required: ['name', 'value'],
                additionalProperties: false,
            },
            minItems: 1,
        },
        actions: {
            type: 'array',
            items: {
                oneOf: [
                    {
                        type: 'object',
                        properties: {
                            name: {
                                type: 'string',
                                enum: ['send-message'],
                            },
                            params: {
                                type: 'object',
                                nullable: true,
                                properties: {
                                    sender: {
                                        type: 'string',
                                        enum: ['queue', 'custom'],
                                    },
                                    msg: {
                                        type: 'string',
                                    },
                                    name: {
                                        type: 'string',
                                        nullable: true,
                                    },
                                },
                                required: ['sender', 'msg'],
                                additionalProperties: false,
                            },
                        },
                        required: ['name'],
                        additionalProperties: false,
                    },
                    {
                        type: 'object',
                        properties: {
                            name: {
                                type: 'string',
                                enum: ['use-external-service'],
                            },
                            params: {
                                type: 'object',
                                nullable: true,
                                properties: {
                                    sender: {
                                        type: 'string',
                                        enum: ['queue', 'custom'],
                                    },
                                    name: {
                                        type: 'string',
                                        nullable: true,
                                    },
                                    serviceUrl: {
                                        type: 'string',
                                    },
                                    serviceTimeout: {
                                        type: 'number',
                                    },
                                    serviceFallbackMessage: {
                                        type: 'string',
                                    },
                                },
                                required: ['serviceUrl', 'serviceTimeout', 'serviceFallbackMessage'],
                                additionalProperties: false,
                            },
                        },
                        required: ['name'],
                        additionalProperties: false,
                    },
                ],
            },
            minItems: 1,
        },
        _id: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['name', 'description', 'enabled', 'runOnce', 'conditions', 'actions'],
    additionalProperties: false,
};
export const isPOSTLivechatTriggersParams = ajv.compile(POSTLivechatTriggersParamsSchema);
const POSTLivechatAppearanceParamsSchema = {
    type: 'array',
    items: {
        type: 'object',
        properties: {
            _id: {
                type: 'string',
            },
            value: {
                // Be careful with anyOf - https://github.com/ajv-validator/ajv/issues/1140
                type: ['string', 'boolean', 'number', 'array'],
            },
        },
        required: ['_id', 'value'],
        additionalProperties: false,
    },
    minItems: 1,
};
export const isPOSTLivechatAppearanceParams = ajv.compile(POSTLivechatAppearanceParamsSchema);
const GETDashboardConversationsByTypeSchema = {
    type: 'object',
    properties: {
        start: {
            type: 'string',
        },
        end: {
            type: 'string',
        },
        sort: {
            type: 'string',
        },
    },
    required: ['start', 'end'],
    additionalProperties: false,
};
export const isGETDashboardConversationsByType = ajv.compile(GETDashboardConversationsByTypeSchema);
const LivechatAnalyticsAgentOverviewPropsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        from: {
            type: 'string',
        },
        to: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['name', 'from', 'to'],
    additionalProperties: false,
};
export const isLivechatAnalyticsAgentOverviewProps = ajv.compile(LivechatAnalyticsAgentOverviewPropsSchema);
const LivechatAnalyticsOverviewPropsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
        from: {
            type: 'string',
        },
        to: {
            type: 'string',
        },
        departmentId: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['name', 'from', 'to'],
    additionalProperties: false,
};
export const isLivechatAnalyticsOverviewProps = ajv.compile(LivechatAnalyticsOverviewPropsSchema);
const LivechatTriggerWebhookTestParamsSchema = {
    type: 'object',
    properties: {
        webhookUrl: {
            type: 'string',
        },
        timeout: {
            type: 'number',
        },
        fallbackMessage: {
            type: 'string',
        },
        extraData: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    key: {
                        type: 'string',
                    },
                    value: {
                        type: 'string',
                    },
                },
                required: ['key', 'value'],
                additionalProperties: false,
            },
            nullable: true,
        },
    },
    required: ['webhookUrl', 'timeout', 'fallbackMessage'],
    additionalProperties: false,
};
export const isLivechatTriggerWebhookTestParams = ajv.compile(LivechatTriggerWebhookTestParamsSchema);
const LivechatTriggerWebhookCallParamsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
        extraData: {
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    key: {
                        type: 'string',
                    },
                    value: {
                        type: 'string',
                    },
                },
                required: ['key', 'value'],
                additionalProperties: false,
            },
            nullable: true,
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isLivechatTriggerWebhookCallParams = ajv.compile(LivechatTriggerWebhookCallParamsSchema);
const POSTLivechatRoomsCloseAllSchema = {
    type: 'object',
    properties: {
        departmentIds: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
    },
    required: [],
    nullable: true,
    additionalProperties: false,
};
export const isPOSTLivechatRoomsCloseAll = ajv.compile(POSTLivechatRoomsCloseAllSchema);
const POSTLivechatRoomsCloseAllSuccessResponseSchema = {
    type: 'object',
    properties: {
        removedRooms: {
            type: 'number',
        },
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    required: ['removedRooms'],
    additionalProperties: false,
};
export const isPOSTLivechatRoomsCloseAllSuccessResponse = ajv.compile(POSTLivechatRoomsCloseAllSuccessResponseSchema);
const POSTLivechatRemoveRoomParamsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isPOSTLivechatRemoveRoomParams = ajv.compile(POSTLivechatRemoveRoomParamsSchema);
const POSTLivechatRemoveRoomSuccessSchema = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTLivechatRemoveRoomSuccess = ajv.compile(POSTLivechatRemoveRoomSuccessSchema);
const POSTLivechatRemoveCustomFieldsSchema = {
    type: 'object',
    properties: {
        customFieldId: {
            type: 'string',
        },
    },
    required: ['customFieldId'],
    additionalProperties: false,
};
export const isPOSTLivechatRemoveCustomFields = ajv.compile(POSTLivechatRemoveCustomFieldsSchema);
const POSTLivechatSaveCustomFieldsSchema = {
    type: 'object',
    properties: {
        customFieldId: {
            type: 'string',
        },
        customFieldData: {
            type: 'object',
            properties: {
                field: {
                    type: 'string',
                },
                label: {
                    type: 'string',
                },
                scope: {
                    type: 'string',
                    enum: ['visitor', 'room'],
                },
                visibility: {
                    type: 'string',
                },
                type: {
                    type: 'string',
                    nullable: true,
                },
                regexp: {
                    type: 'string',
                    nullable: true,
                },
                required: {
                    type: 'boolean',
                    nullable: true,
                },
                defaultValue: {
                    type: 'string',
                    nullable: true,
                },
                options: {
                    type: 'string',
                    nullable: true,
                },
                public: {
                    type: 'boolean',
                    nullable: true,
                },
                searchable: {
                    type: 'boolean',
                    nullable: true,
                },
            },
        },
    },
    additionalProperties: false,
};
export const isPOSTLivechatSaveCustomFieldsParams = ajv.compile(POSTLivechatSaveCustomFieldsSchema);
const POSTLivechatSaveCustomFieldSuccessSchema = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
        customField: {
            type: 'object',
            properties: {
                label: {
                    type: 'string',
                },
                scope: {
                    type: 'string',
                    enum: ['visitor', 'room'],
                },
                visibility: {
                    type: 'string',
                },
                type: {
                    type: 'string',
                    nullable: true,
                },
                regexp: {
                    type: 'string',
                    nullable: true,
                },
                required: {
                    type: 'boolean',
                    nullable: true,
                },
                defaultValue: {
                    type: 'string',
                    nullable: true,
                },
                options: {
                    type: 'string',
                    nullable: true,
                },
                public: {
                    type: 'boolean',
                    nullable: true,
                },
                searchable: {
                    type: 'boolean',
                    nullable: true,
                },
            },
        },
    },
    additionalProperties: false,
};
export const POSTLivechatSaveCustomFieldSuccess = ajv.compile(POSTLivechatSaveCustomFieldSuccessSchema);
const POSTLivechatRemoveCustomFieldSuccessSchema = {
    type: 'object',
    properties: {
        success: {
            type: 'boolean',
            enum: [true],
        },
    },
    additionalProperties: false,
};
export const POSTLivechatRemoveCustomFieldSuccess = ajv.compile(POSTLivechatRemoveCustomFieldSuccessSchema);
//# sourceMappingURL=omnichannel.js.map