import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const ShieldSvgSchema = {
    type: 'object',
    properties: {
        type: {
            type: 'string',
            nullable: true,
        },
        icon: {
            type: 'string',
            enum: ['true', 'false'],
            nullable: true,
        },
        channel: {
            type: 'string',
        },
        name: {
            type: 'string',
        },
    },
    required: ['name', 'channel'],
    additionalProperties: false,
};
export const isShieldSvgProps = ajv.compile(ShieldSvgSchema);
const SpotlightSchema = {
    type: 'object',
    properties: {
        query: {
            type: 'string',
        },
    },
    required: ['query'],
    additionalProperties: false,
};
export const isSpotlightProps = ajv.compile(SpotlightSchema);
const DirectorySchema = {
    type: 'object',
    properties: {
        text: {
            type: 'string',
            nullable: true,
        },
        type: {
            type: 'string',
            nullable: true,
        },
        workspace: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isDirectoryProps = ajv.compile(DirectorySchema);
const MethodCallSchema = {
    type: 'object',
    properties: {
        method: {
            type: 'string',
        },
        params: {
            type: 'array',
        },
        id: {
            type: 'string',
        },
        msg: {
            type: 'string',
            enum: ['method'],
        },
    },
    required: ['method', 'params', 'id', 'msg'],
    additionalProperties: false,
};
export const isMethodCallProps = ajv.compile(MethodCallSchema);
export const isMeteorCall = ajv.compile({
    type: 'object',
    properties: {
        message: {
            type: 'string',
        },
    },
    required: ['message'],
    additionalProperties: false,
});
const MethodCallAnonSchema = {
    type: 'object',
    properties: {
        method: {
            type: 'string',
        },
        params: {
            type: 'array',
        },
        id: {
            type: 'string',
        },
        msg: {
            type: 'string',
            enum: ['method'],
        },
    },
    required: ['method', 'params', 'id', 'msg'],
    additionalProperties: false,
};
export const isMethodCallAnonProps = ajv.compile(MethodCallAnonSchema);
const FingerprintSchema = {
    type: 'object',
    properties: {
        setDeploymentAs: {
            type: 'string',
            enum: ['new-workspace', 'updated-configuration'],
        },
    },
    required: ['setDeploymentAs'],
    additionalProperties: false,
};
export const isFingerprintProps = ajv.compile(FingerprintSchema);
//# sourceMappingURL=misc.js.map