import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const UseInviteTokenPropsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isUseInviteTokenProps = ajv.compile(UseInviteTokenPropsSchema);
const ValidateInviteTokenPropsSchema = {
    type: 'object',
    properties: {
        token: {
            type: 'string',
        },
    },
    required: ['token'],
    additionalProperties: false,
};
export const isValidateInviteTokenProps = ajv.compile(ValidateInviteTokenPropsSchema);
const FindOrCreateInviteParamsSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        days: {
            type: 'integer',
        },
        maxUses: {
            type: 'integer',
        },
    },
    required: ['rid', 'days', 'maxUses'],
    additionalProperties: false,
};
export const isFindOrCreateInviteParams = ajv.compile(FindOrCreateInviteParamsSchema);
const SendInvitationEmailParamsSchema = {
    type: 'object',
    properties: {
        emails: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
    },
    required: ['emails'],
    additionalProperties: false,
};
export const isSendInvitationEmailParams = ajv.compile(SendInvitationEmailParamsSchema);
//# sourceMappingURL=invites.js.map