import { ajv } from './Ajv';
const chatSendMessageSchema = {
    type: 'object',
    properties: {
        message: {
            type: 'object',
            properties: {
                _id: {
                    type: 'string',
                    nullable: true,
                },
                rid: {
                    type: 'string',
                },
                tmid: {
                    type: 'string',
                    nullable: true,
                },
                msg: {
                    type: 'string',
                    nullable: true,
                },
                alias: {
                    type: 'string',
                    nullable: true,
                },
                emoji: {
                    type: 'string',
                    nullable: true,
                },
                tshow: {
                    type: 'boolean',
                    nullable: true,
                },
                avatar: {
                    type: 'string',
                    nullable: true,
                },
                attachments: {
                    type: 'array',
                    items: {
                        type: 'object',
                    },
                    nullable: true,
                },
                blocks: {
                    type: 'array',
                    items: {
                        type: 'object',
                    },
                    nullable: true,
                },
                customFields: {
                    type: 'object',
                    nullable: true,
                },
            },
        },
        previewUrls: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
    },
    required: ['message'],
    additionalProperties: false,
};
export const isChatSendMessageProps = ajv.compile(chatSendMessageSchema);
const chatFollowMessageSchema = {
    type: 'object',
    properties: {
        mid: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['mid'],
    additionalProperties: false,
};
export const isChatFollowMessageProps = ajv.compile(chatFollowMessageSchema);
const chatUnfollowMessageSchema = {
    type: 'object',
    properties: {
        mid: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['mid'],
    additionalProperties: false,
};
export const isChatUnfollowMessageProps = ajv.compile(chatUnfollowMessageSchema);
const ChatGetMessageSchema = {
    type: 'object',
    properties: {
        msgId: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['msgId'],
    additionalProperties: false,
};
export const isChatGetMessageProps = ajv.compile(ChatGetMessageSchema);
const ChatStarMessageSchema = {
    type: 'object',
    properties: {
        messageId: {
            type: 'string',
        },
    },
    required: ['messageId'],
    additionalProperties: false,
};
export const isChatStarMessageProps = ajv.compile(ChatStarMessageSchema);
const ChatUnstarMessageSchema = {
    type: 'object',
    properties: {
        messageId: {
            type: 'string',
        },
    },
    required: ['messageId'],
    additionalProperties: false,
};
export const isChatUnstarMessageProps = ajv.compile(ChatUnstarMessageSchema);
const ChatGetDiscussionsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        text: {
            type: 'string',
        },
        offset: {
            type: 'number',
        },
        count: {
            type: 'number',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChatGetDiscussionsProps = ajv.compile(ChatGetDiscussionsSchema);
const ChatReportMessageSchema = {
    type: 'object',
    properties: {
        messageId: {
            type: 'string',
        },
        description: {
            type: 'string',
        },
    },
    required: ['messageId', 'description'],
    additionalProperties: false,
};
export const isChatReportMessageProps = ajv.compile(ChatReportMessageSchema);
const ChatGetThreadsListSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        type: {
            type: 'string',
            enum: ['following', 'unread'],
            nullable: true,
        },
        text: {
            type: 'string',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
        fields: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isChatGetThreadsListProps = ajv.compile(ChatGetThreadsListSchema);
const ChatSyncThreadsListSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
            minLength: 1,
        },
        updatedSince: {
            type: 'string',
            format: 'iso-date-time',
        },
    },
    required: ['rid', 'updatedSince'],
    additionalProperties: false,
};
export const isChatSyncThreadsListProps = ajv.compile(ChatSyncThreadsListSchema);
const ChatDeleteSchema = {
    type: 'object',
    properties: {
        msgId: {
            type: 'string',
        },
        roomId: {
            type: 'string',
        },
        asUser: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: ['msgId', 'roomId'],
    additionalProperties: false,
};
export const isChatDeleteProps = ajv.compile(ChatDeleteSchema);
const ChatReactSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                emoji: {
                    type: 'string',
                },
                messageId: {
                    type: 'string',
                    minLength: 1,
                },
                shouldReact: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['emoji', 'messageId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                reaction: {
                    type: 'string',
                },
                messageId: {
                    type: 'string',
                    minLength: 1,
                },
                shouldReact: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['reaction', 'messageId'],
            additionalProperties: false,
        },
    ],
};
export const isChatReactProps = ajv.compile(ChatReactSchema);
const ChatIgnoreUserSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
            minLength: 1,
        },
        userId: {
            type: 'string',
            minLength: 1,
        },
        ignore: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['rid', 'userId', 'ignore'],
    additionalProperties: false,
};
export const isChatIgnoreUserProps = ajv.compile(ChatIgnoreUserSchema);
const ChatSearchSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        searchText: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
    },
    required: ['roomId', 'searchText'],
    additionalProperties: false,
};
export const isChatSearchProps = ajv.compile(ChatSearchSchema);
const ChatUpdateSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
                msgId: {
                    type: 'string',
                },
                text: {
                    type: 'string',
                },
                previewUrls: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                customFields: {
                    type: 'object',
                    nullable: true,
                },
            },
            required: ['roomId', 'msgId', 'text'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
                msgId: {
                    type: 'string',
                },
                content: {
                    type: 'object',
                    discriminator: {
                        propertyName: 'algorithm',
                    },
                    oneOf: [
                        {
                            type: 'object',
                            properties: {
                                algorithm: {
                                    const: 'rc.v1.aes-sha2',
                                },
                                ciphertext: {
                                    type: 'string',
                                    minLength: 1,
                                },
                            },
                            required: ['algorithm', 'ciphertext'],
                            additionalProperties: false,
                        },
                        {
                            type: 'object',
                            properties: {
                                algorithm: {
                                    const: 'rc.v2.aes-sha2',
                                },
                                ciphertext: {
                                    type: 'string',
                                    minLength: 1,
                                },
                                iv: {
                                    type: 'string',
                                    minLength: 1,
                                },
                                kid: {
                                    type: 'string',
                                    minLength: 1,
                                },
                            },
                            required: ['algorithm', 'ciphertext', 'iv', 'kid'],
                            additionalProperties: false,
                        },
                    ],
                },
                e2eMentions: {
                    type: 'object',
                    properties: {
                        e2eUserMentions: {
                            type: 'array',
                            items: { type: 'string' },
                            nullable: true,
                        },
                        e2eChannelMentions: {
                            type: 'array',
                            items: { type: 'string' },
                            nullable: true,
                        },
                    },
                    required: [],
                    additionalProperties: false,
                    nullable: true,
                },
            },
            required: ['roomId', 'msgId', 'content'],
            additionalProperties: false,
        },
    ],
};
export const isChatUpdateProps = ajv.compile(ChatUpdateSchema);
const ChatGetMessageReadReceiptsSchema = {
    type: 'object',
    properties: {
        messageId: {
            type: 'string',
        },
    },
    required: ['messageId'],
    additionalProperties: false,
};
export const isChatGetMessageReadReceiptsProps = ajv.compile(ChatGetMessageReadReceiptsSchema);
const GetStarredMessagesSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChatGetStarredMessagesProps = ajv.compile(GetStarredMessagesSchema);
const GetPinnedMessagesSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChatGetPinnedMessagesProps = ajv.compile(GetPinnedMessagesSchema);
const GetMentionedMessagesSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChatGetMentionedMessagesProps = ajv.compile(GetMentionedMessagesSchema);
const ChatSyncMessagesSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        lastUpdate: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        next: {
            type: 'string',
            nullable: true,
        },
        previous: {
            type: 'string',
            nullable: true,
        },
        type: {
            type: 'string',
            enum: ['UPDATED', 'DELETED'],
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChatSyncMessagesProps = ajv.compile(ChatSyncMessagesSchema);
const ChatSyncThreadMessagesSchema = {
    type: 'object',
    properties: {
        tmid: {
            type: 'string',
            minLength: 1,
        },
        updatedSince: {
            type: 'string',
            format: 'iso-date-time',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['tmid', 'updatedSince'],
    additionalProperties: false,
};
export const isChatSyncThreadMessagesProps = ajv.compile(ChatSyncThreadMessagesSchema);
const ChatGetThreadMessagesSchema = {
    type: 'object',
    properties: {
        tmid: {
            type: 'string',
            minLength: 1,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['tmid'],
    additionalProperties: false,
};
export const isChatGetThreadMessagesProps = ajv.compile(ChatGetThreadMessagesSchema);
const ChatGetDeletedMessagesSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        since: {
            type: 'string',
            minLength: 1,
            format: 'iso-date-time',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId', 'since'],
    additionalProperties: false,
};
export const isChatGetDeletedMessagesProps = ajv.compile(ChatGetDeletedMessagesSchema);
const ChatPostMessageSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    oneOf: [
                        { type: 'string' },
                        {
                            type: 'array',
                            items: {
                                type: 'string',
                            },
                        },
                    ],
                },
                text: {
                    type: 'string',
                    nullable: true,
                },
                alias: {
                    type: 'string',
                    nullable: true,
                },
                emoji: {
                    type: 'string',
                    nullable: true,
                },
                avatar: {
                    type: 'string',
                    nullable: true,
                },
                attachments: {
                    type: 'array',
                    items: {
                        type: 'object',
                    },
                    nullable: true,
                },
                tmid: {
                    type: 'string',
                },
                customFields: {
                    type: 'object',
                    nullable: true,
                },
                parseUrls: {
                    type: 'boolean',
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                channel: {
                    oneOf: [
                        { type: 'string' },
                        {
                            type: 'array',
                            items: {
                                type: 'string',
                            },
                        },
                    ],
                },
                text: {
                    type: 'string',
                    nullable: true,
                },
                alias: {
                    type: 'string',
                    nullable: true,
                },
                emoji: {
                    type: 'string',
                    nullable: true,
                },
                avatar: {
                    type: 'string',
                    nullable: true,
                },
                attachments: {
                    type: 'array',
                    items: {
                        type: 'object',
                    },
                    nullable: true,
                },
                customFields: {
                    type: 'object',
                    nullable: true,
                },
                parseUrls: {
                    type: 'boolean',
                },
            },
            required: ['channel'],
            additionalProperties: false,
        },
    ],
};
export const isChatPostMessageProps = ajv.compile(ChatPostMessageSchema);
const ChatGetURLPreviewSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        url: {
            type: 'string',
        },
    },
    required: ['roomId', 'url'],
    additionalProperties: false,
};
export const isChatGetURLPreviewProps = ajv.compile(ChatGetURLPreviewSchema);
const ChatOTRSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
        type: {
            type: 'string',
            enum: ['user_joined_otr', 'user_requested_otr_key_refresh', 'user_key_refreshed_successfully'],
        },
    },
    required: ['roomId', 'type'],
    additionalProperties: false,
};
export const isChatOTRProps = ajv.compile(ChatOTRSchema);
//# sourceMappingURL=chat.js.map