import Ajv from 'ajv';
const ajv = new Ajv({ coerceTypes: true });
const channelsMessagesPropsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        mentionIds: {
            type: 'string',
        },
        starredIds: {
            type: 'string',
        },
        pinned: {
            type: 'string',
        },
        query: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isChannelsMessagesProps = ajv.compile(channelsMessagesPropsSchema);
//# sourceMappingURL=ChannelsMessagesProps.js.map