import Ajv from 'ajv';
const ajv = new Ajv();
const calendarEventUpdatePropsSchema = {
    type: 'object',
    properties: {
        eventId: {
            type: 'string',
            nullable: false,
        },
        startTime: {
            type: 'string',
            nullable: false,
        },
        endTime: {
            type: 'string',
            nullable: true,
        },
        subject: {
            type: 'string',
            nullable: false,
        },
        description: {
            type: 'string',
            nullable: false,
        },
        meetingUrl: {
            type: 'string',
            nullable: true,
        },
        reminderMinutesBeforeStart: {
            type: 'number',
            nullable: true,
        },
        busy: {
            type: 'boolean',
            nullable: true,
        },
    },
    required: ['eventId', 'startTime', 'subject', 'description'],
    additionalProperties: false,
};
export const isCalendarEventUpdateProps = ajv.compile(calendarEventUpdatePropsSchema);
//# sourceMappingURL=CalendarEventUpdateProps.js.map