import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const BannersGetNewSchema = {
    type: 'object',
    properties: {
        platform: {
            type: 'string',
            enum: ['web', 'mobile'],
        },
        bid: {
            type: 'string',
        },
    },
    required: ['platform'],
    additionalProperties: false,
};
export const isBannersGetNewProps = ajv.compile(BannersGetNewSchema);
const BannersSchema = {
    type: 'object',
    properties: {
        platform: {
            type: 'string',
            enum: ['web', 'mobile'],
        },
    },
    required: ['platform'],
    additionalProperties: false,
};
export const isBannersProps = ajv.compile(BannersSchema);
const BannersDismissSchema = {
    type: 'object',
    properties: {
        bannerId: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['bannerId'],
    additionalProperties: false,
};
export const isBannersDismissProps = ajv.compile(BannersDismissSchema);
//# sourceMappingURL=banners.js.map