"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processPresenceAndStatus = exports.processStatus = exports.processConnectionStatus = void 0;
const core_typings_1 = require("@rocket.chat/core-typings");
/**
 * Defines new connection status compared to a previous connection status
 */
const processConnectionStatus = (current, status) => {
    if (current === core_typings_1.UserStatus.ONLINE) {
        return core_typings_1.UserStatus.ONLINE;
    }
    if (status !== core_typings_1.UserStatus.OFFLINE) {
        return status;
    }
    return current;
};
exports.processConnectionStatus = processConnectionStatus;
/**
 * Defines user's status based on presence and connection status
 */
const processStatus = (statusConnection, statusDefault) => {
    if (statusConnection === core_typings_1.UserStatus.OFFLINE) {
        return statusConnection;
    }
    if (statusDefault === core_typings_1.UserStatus.ONLINE) {
        return statusConnection;
    }
    return statusDefault;
};
exports.processStatus = processStatus;
/**
 * Defines user's status and connection status based on user's connections and default status
 */
const processPresenceAndStatus = (userSessions = [], statusDefault = core_typings_1.UserStatus.ONLINE) => {
    const statusConnection = userSessions.map((s) => s.status).reduce(exports.processConnectionStatus, core_typings_1.UserStatus.OFFLINE);
    const status = (0, exports.processStatus)(statusConnection, statusDefault);
    return {
        status,
        statusConnection,
    };
};
exports.processPresenceAndStatus = processPresenceAndStatus;
//# sourceMappingURL=processConnectionStatus.js.map