"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Markup = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const BigEmojiBlock_1 = __importDefault(require("./blocks/BigEmojiBlock"));
const CodeBlock_1 = __importDefault(require("./blocks/CodeBlock"));
const HeadingBlock_1 = __importDefault(require("./blocks/HeadingBlock"));
const OrderedListBlock_1 = __importDefault(require("./blocks/OrderedListBlock"));
const ParagraphBlock_1 = __importDefault(require("./blocks/ParagraphBlock"));
const UnorderedListBlock_1 = __importDefault(require("./blocks/UnorderedListBlock"));
const Markup = ({ tokens }) => ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: tokens
        .map((child, index) => {
        switch (child.type) {
            case 'PARAGRAPH':
                return (0, jsx_runtime_1.jsx)(ParagraphBlock_1.default, { items: child.value }, index);
            case 'HEADING':
                return (0, jsx_runtime_1.jsx)(HeadingBlock_1.default, { level: child.level, items: child.value }, index);
            case 'UNORDERED_LIST':
                return (0, jsx_runtime_1.jsx)(UnorderedListBlock_1.default, { items: child.value }, index);
            case 'ORDERED_LIST':
                return (0, jsx_runtime_1.jsx)(OrderedListBlock_1.default, { items: child.value }, index);
            case 'BIG_EMOJI':
                return (0, jsx_runtime_1.jsx)(BigEmojiBlock_1.default, { emoji: child.value }, index);
            case 'CODE':
                return (0, jsx_runtime_1.jsx)(CodeBlock_1.default, { lines: child.value }, index);
            default:
                return null;
        }
    })
        .filter(Boolean) }));
exports.Markup = Markup;
//# sourceMappingURL=index.js.map