"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const EmojiSpan_1 = __importDefault(require("./EmojiSpan"));
const ItalicSpan_1 = __importDefault(require("./ItalicSpan"));
const LinkSpan_1 = __importDefault(require("./LinkSpan"));
const StrikeSpan_1 = __importDefault(require("./StrikeSpan"));
const styles = renderer_1.StyleSheet.create({
    bold: {
        fontWeight: 700,
    },
});
const BoldSpan = ({ children }) => ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: children.map((child, index) => {
        if (child.type === 'LINK' || child.type === 'PLAIN_TEXT' || child.type === 'ITALIC' || child.type === 'STRIKE') {
            return ((0, jsx_runtime_1.jsx)(renderer_1.View, { style: styles.bold, children: renderBlockComponent(child, index) }, index));
        }
        return renderBlockComponent(child, index);
    }) }));
const renderBlockComponent = (child, index) => {
    switch (child.type) {
        case 'LINK':
            return (0, jsx_runtime_1.jsx)(LinkSpan_1.default, { label: Array.isArray(child.value.label) ? child.value.label : [child.value.label] }, index);
        case 'PLAIN_TEXT':
            return (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: child.value }, index);
        case 'STRIKE':
            return (0, jsx_runtime_1.jsx)(StrikeSpan_1.default, { children: child.value }, index);
        case 'ITALIC':
            return (0, jsx_runtime_1.jsx)(ItalicSpan_1.default, { children: child.value }, index);
        case 'EMOJI':
            return (0, jsx_runtime_1.jsx)(EmojiSpan_1.default, { ...child }, index);
        default:
            return null;
    }
};
exports.default = BoldSpan;
//# sourceMappingURL=BoldSpan.js.map