"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatTranscriptPDF = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const path = __importStar(require("path"));
const renderer_1 = __importStar(require("@react-pdf/renderer"));
const colors_json_1 = __importDefault(require("@rocket.chat/fuselage-tokens/colors.json"));
const react_i18next_1 = require("react-i18next");
const Header_1 = require("./components/Header");
const MessageList_1 = require("./components/MessageList");
const FONT_PATH = path.resolve(__dirname, '../../public');
const styles = renderer_1.StyleSheet.create({
    page: {
        fontFamily: 'Inter',
        lineHeight: 1.25,
        color: colors_json_1.default.n800,
        // ugh https://github.com/diegomura/react-pdf/issues/684
        paddingBottom: 32,
    },
    wrapper: {
        paddingHorizontal: 32,
    },
    message: {
        wordWrap: 'break-word',
        fontSize: 12,
        marginBottom: 20,
        textAlign: 'justify',
    },
});
const ChatTranscriptPDF = ({ header, messages }) => {
    const { t } = (0, react_i18next_1.useTranslation)();
    const agentValue = header.agent?.name || header.agent?.username || t('Not_assigned');
    const customerValue = header.visitor?.name || header.visitor?.username || t('Guest');
    const dateValue = header.date;
    const timeValue = header.time;
    return ((0, jsx_runtime_1.jsx)(renderer_1.Document, { children: (0, jsx_runtime_1.jsxs)(renderer_1.Page, { size: 'A4', style: styles.page, wrap: true, children: [(0, jsx_runtime_1.jsx)(Header_1.Header, { title: header.siteName, subtitle: t('Chat_transcript'), values: [
                        { key: t('Agent'), value: agentValue },
                        { key: t('Date'), value: dateValue },
                        { key: t('Customer'), value: customerValue },
                        { key: t('Time'), value: timeValue },
                    ] }), (0, jsx_runtime_1.jsx)(MessageList_1.MessageList, { messages: messages, invalidFileMessage: t('This_attachment_is_not_supported') })] }) }));
};
exports.ChatTranscriptPDF = ChatTranscriptPDF;
exports.default = async ({ i18n, ...data }) => {
    renderer_1.Font.register({
        family: 'Inter',
        fonts: [
            { src: `${FONT_PATH}/inter400.ttf` },
            { src: `${FONT_PATH}/inter400-italic.ttf`, fontStyle: 'italic' },
            { src: `${FONT_PATH}/inter500.ttf`, fontWeight: 500 },
            { src: `${FONT_PATH}/inter500-italic.ttf`, fontWeight: 500, fontStyle: 'italic' },
            { src: `${FONT_PATH}/inter700.ttf`, fontWeight: 700 },
            { src: `${FONT_PATH}/inter700-italic.ttf`, fontWeight: 700, fontStyle: 'italic' },
        ],
    });
    renderer_1.Font.register({
        family: 'FiraCode',
        fonts: [{ src: `${FONT_PATH}/fira-code700.ttf`, fontWeight: 700 }],
    });
    renderer_1.Font.registerHyphenationCallback((word) => [word]);
    return renderer_1.default.renderToStream((0, jsx_runtime_1.jsx)(react_i18next_1.I18nextProvider, { i18n: i18n, children: (0, jsx_runtime_1.jsx)(exports.ChatTranscriptPDF, { ...data }) }));
};
//# sourceMappingURL=index.js.map