"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const typography_json_1 = require("@rocket.chat/fuselage-tokens/typography.json");
const markup_1 = require("../markup");
const Divider_1 = require("./Divider");
const Files_1 = require("./Files");
const MessageHeader_1 = require("./MessageHeader");
const Quotes_1 = require("./Quotes");
const utils_1 = require("./utils");
const styles = renderer_1.StyleSheet.create({
    wrapper: {
        marginBottom: 16,
        paddingBottom: 16,
        paddingHorizontal: 32,
    },
    message: {
        marginTop: 1,
        fontSize: typography_json_1.fontScales.p2.fontSize,
    },
    systemMessage: {
        fontStyle: 'italic',
    },
});
const processMd = (message) => (0, utils_1.splitByTens)(message.md).map((chunk, index) => ((0, jsx_runtime_1.jsx)(renderer_1.View, { style: { ...styles.message, ...((0, utils_1.isSystemMessage)(message) && styles.systemMessage) }, children: (0, jsx_runtime_1.jsx)(markup_1.Markup, { tokens: chunk }) }, index)));
const processMessage = (message) => {
    if (message.md) {
        if ((0, utils_1.markupEntriesGreaterThan10)(message.md)) {
            return processMd(message);
        }
        return ((0, jsx_runtime_1.jsx)(renderer_1.View, { style: { ...styles.message, ...((0, utils_1.isSystemMessage)(message) && styles.systemMessage) }, children: (0, jsx_runtime_1.jsx)(markup_1.Markup, { tokens: message.md }) }));
    }
    return ((0, jsx_runtime_1.jsx)(renderer_1.View, { style: { ...styles.message, ...((0, utils_1.isSystemMessage)(message) && styles.systemMessage) }, children: (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: message.msg }) }));
};
const Message = ({ message, invalidFileMessage }) => ((0, jsx_runtime_1.jsxs)(renderer_1.View, { style: styles.wrapper, wrap: !!message.quotes || (0, utils_1.messageLongerThanPage)(message.msg), children: [message.divider && (0, jsx_runtime_1.jsx)(Divider_1.Divider, { divider: message.divider }), (0, jsx_runtime_1.jsx)(MessageHeader_1.MessageHeader, { name: message.u.name || message.u.username, time: message.ts }), processMessage(message), message.quotes && (0, jsx_runtime_1.jsx)(Quotes_1.Quotes, { quotes: message.quotes }), message.files && (0, jsx_runtime_1.jsx)(Files_1.Files, { files: message.files, invalidMessage: invalidFileMessage })] }));
exports.default = Message;
//# sourceMappingURL=Message.js.map