"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatTranscript = void 0;
const moment_timezone_1 = __importDefault(require("moment-timezone"));
const ChatTranscript_1 = __importDefault(require("../templates/ChatTranscript"));
class ChatTranscript {
    constructor() {
        this.isChatTranscriptData = (data) => {
            return (typeof data === 'object' &&
                data !== null &&
                'header' in data &&
                'messages' in data &&
                'i18n' in data &&
                typeof data.header === 'object' &&
                data.header !== null &&
                'agent' in data.header &&
                'visitor' in data.header &&
                'siteName' in data.header &&
                'date' in data.header &&
                'time' in data.header);
        };
    }
    isNewDay(current, previous, timezone) {
        return !previous || !(0, moment_timezone_1.default)(current.ts).tz(timezone).isSame(previous.ts, 'day');
    }
    parserMessages(messages, dateFormat, timeAndDateFormat, timezone) {
        return messages.map((message, index, arr) => {
            const previousMessage = arr[index - 1];
            const { ts, quotes, requestData, webRtcCallEndTs, ...rest } = message;
            const isDivider = this.isNewDay(message, previousMessage, timezone);
            const formattedTs = (0, moment_timezone_1.default)(ts).tz(timezone).format(timeAndDateFormat);
            const formattedQuotes = quotes?.map((quote) => ({
                ...quote,
                ts: (0, moment_timezone_1.default)(quote.ts).tz(timezone).format(timeAndDateFormat),
            }));
            const formattedRequestData = requestData
                ? {
                    ...requestData,
                    visitor: requestData.visitor
                        ? {
                            ...requestData.visitor,
                            ts: (0, moment_timezone_1.default)(requestData.visitor.ts).tz(timezone).format(timeAndDateFormat),
                            lastChat: requestData.visitor.lastChat
                                ? {
                                    ...requestData.visitor.lastChat,
                                    ts: (0, moment_timezone_1.default)(requestData.visitor.lastChat.ts).tz(timezone).format(timeAndDateFormat),
                                }
                                : undefined,
                            lastAgent: requestData.visitor.lastAgent
                                ? {
                                    ...requestData.visitor.lastAgent,
                                    ts: (0, moment_timezone_1.default)(requestData.visitor.lastAgent.ts).tz(timezone).format(timeAndDateFormat),
                                }
                                : undefined,
                            livechatData: requestData.visitor.livechatData
                                ? Object.fromEntries(Object.entries(requestData.visitor.livechatData).map(([key]) => [key, null]))
                                : undefined,
                            _updatedAt: requestData.visitor._updatedAt
                                ? (0, moment_timezone_1.default)(requestData.visitor._updatedAt).tz(timezone).format(timeAndDateFormat)
                                : '',
                        }
                        : undefined,
                }
                : undefined;
            const formattedWebRtcCallEndTs = webRtcCallEndTs ? (0, moment_timezone_1.default)(webRtcCallEndTs).tz(timezone).format(timeAndDateFormat) : undefined;
            return {
                ...rest,
                ts: formattedTs,
                quotes: formattedQuotes,
                requestData: formattedRequestData,
                webRtcCallEndTs: formattedWebRtcCallEndTs,
                ...(isDivider && { divider: (0, moment_timezone_1.default)(ts).tz(timezone).format(dateFormat) }),
            };
        });
    }
    renderTemplate(data) {
        if (!this.isChatTranscriptData(data)) {
            throw new Error('Invalid data');
        }
        return (0, ChatTranscript_1.default)(data);
    }
    parseTemplateData(data, i18n) {
        return {
            header: {
                visitor: data.visitor,
                agent: data.agent,
                siteName: data.siteName,
                date: `${(0, moment_timezone_1.default)(data.closedAt).tz(data.timezone).format(String(data.dateFormat))}`,
                time: `${(0, moment_timezone_1.default)(data.closedAt).tz(data.timezone).format('H:mm:ss')} ${data.timezone}`,
            },
            messages: this.parserMessages(data.messages, data.dateFormat, data.timeAndDateFormat, data.timezone),
            i18n,
        };
    }
}
exports.ChatTranscript = ChatTranscript;
//# sourceMappingURL=ChatTranscript.js.map