import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Margins } from '@rocket.chat/fuselage';
import { ActionLink, LayoutLogo, BackgroundLayer } from '@rocket.chat/layout';
import { useEffect, useState } from 'react';
import { useTranslation, Trans } from 'react-i18next';
var RedirectPage = function (_a) {
    var title = _a.title, countDownSeconds = _a.countDownSeconds, onRedirect = _a.onRedirect;
    var t = useTranslation().t;
    var _b = useState(countDownSeconds), seconds = _b[0], setSeconds = _b[1];
    useEffect(function () {
        if (seconds === 0)
            return;
        var timer = setInterval(function () {
            setSeconds(function (prev) { return Math.max(0, prev - 1); });
        }, 1000);
        return function () {
            clearInterval(timer);
        };
    }, []);
    useEffect(function () {
        if (seconds === 0)
            onRedirect();
    }, [seconds]);
    return (_jsx(BackgroundLayer, { children: _jsx(Box, { display: 'flex', flexDirection: 'column', alignItems: 'center', textAlign: 'center', width: '100%', maxWidth: 768, paddingBlock: 32, paddingInline: 16, children: _jsxs(Margins, { blockEnd: 32, children: [_jsx(LayoutLogo, {}), _jsx(Box, { fontScale: 'hero', children: title }), _jsx(Box, { fontScale: 'p1b', children: t('page.redirect.subtitle', { seconds: seconds }) }), _jsx(Box, { fontScale: 'c1', children: _jsxs(Trans, { i18nKey: 'page.redirect.redirectNotWorking', children: ["Redirect not working?", _jsx(ActionLink, { onClick: onRedirect, children: "Open workspace" })] }) })] }) }) }));
};
export default RedirectPage;
//# sourceMappingURL=RedirectPage.js.map