import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Margins, ProgressBar } from '@rocket.chat/fuselage';
import { BackgroundLayer, LayoutLogo } from '@rocket.chat/layout';
import { useEffect, useState } from 'react';
var LoaderPage = function (_a) {
    var title = _a.title, subtitles = _a.subtitles, _b = _a.isReady, isReady = _b === void 0 ? false : _b, _c = _a.loadingSeconds, loadingSeconds = _c === void 0 ? 90 : _c;
    var timeFraction = 100 / subtitles.length;
    var _d = useState(function () { return (isReady ? 100 : 0); }), percentage = _d[0], setPercentage = _d[1];
    useEffect(function () {
        if (isReady) {
            setPercentage(100);
            return;
        }
        var interval = (loadingSeconds * 1000) / 100;
        var timer = setInterval(function () {
            setPercentage(function (prev) { return (prev === 99 ? 99 : prev + 1); });
        }, interval);
        return function () {
            clearInterval(timer);
        };
    }, [isReady]);
    var subtitleIndex = Math.floor(percentage / timeFraction);
    return (_jsx(BackgroundLayer, { children: _jsx(Box, { display: 'flex', flexDirection: 'column', alignItems: 'center', textAlign: 'center', width: '100%', maxWidth: 768, paddingBlock: 32, paddingInline: 16, children: _jsxs(Margins, { blockEnd: 32, children: [_jsx(LayoutLogo, {}), _jsx(Box, { fontScale: 'hero', children: title }), _jsx(Box, { fontScale: 'p1b', children: subtitles[subtitleIndex] }), _jsx(ProgressBar, { percentage: percentage })] }) }) }));
};
export default LoaderPage;
//# sourceMappingURL=LoaderPage.js.map