var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, ButtonGroup, Button, Field, EmailInput, FieldLabel, FieldRow, FieldError, FieldGroup, } from '@rocket.chat/fuselage';
import { useBreakpoints } from '@rocket.chat/fuselage-hooks';
import { Form } from '@rocket.chat/layout';
import { useEffect, useId, useRef } from 'react';
import { Controller, useForm, FormProvider } from 'react-hook-form';
import { useTranslation, Trans } from 'react-i18next';
import AgreeTermsField from '../../common/AgreeTermsField';
var RegisterServerForm = function (_a) {
    var currentStep = _a.currentStep, stepCount = _a.stepCount, initialValues = _a.initialValues, validateEmail = _a.validateEmail, offline = _a.offline, onSubmit = _a.onSubmit, _b = _a.termsHref, termsHref = _b === void 0 ? 'https://rocket.chat/terms' : _b, _c = _a.policyHref, policyHref = _c === void 0 ? 'https://rocket.chat/privacy' : _c, onClickRegisterOffline = _a.onClickRegisterOffline;
    var t = useTranslation().t;
    var formId = useId();
    var emailField = useId();
    var agreementField = useId();
    var registerServerFormRef = useRef(null);
    var breakpoints = useBreakpoints();
    var isMobile = !breakpoints.includes('md');
    var form = useForm({
        mode: 'onBlur',
        defaultValues: __assign({ email: '', agreement: false, updates: true }, initialValues),
    });
    var control = form.control, register = form.register, _d = form.formState, isSubmitting = _d.isSubmitting, isValidating = _d.isValidating, errors = _d.errors, handleSubmit = form.handleSubmit;
    useEffect(function () {
        if (registerServerFormRef.current) {
            registerServerFormRef.current.focus();
        }
    }, []);
    return (_jsx(FormProvider, __assign({}, form, { children: _jsxs(Form, { ref: registerServerFormRef, tabIndex: -1, "aria-labelledby": "".concat(formId, "-title"), "aria-describedby": "".concat(formId, "-informed-disclaimer ").concat(formId, "-engagement-disclaimer"), onSubmit: handleSubmit(onSubmit), children: [_jsxs(Form.Header, { children: [_jsx(Form.Steps, { currentStep: currentStep, stepCount: stepCount }), _jsx(Form.Title, { id: "".concat(formId, "-title"), children: t('form.registeredServerForm.title') })] }), _jsx(Form.Container, { children: _jsxs(FieldGroup, { children: [_jsxs(Field, { children: [_jsx(FieldLabel, { required: true, display: 'flex', alignItems: 'center', htmlFor: emailField, children: t('form.registeredServerForm.fields.accountEmail.inputLabel') }), _jsx(FieldRow, { children: _jsx(Controller, { name: 'email', control: control, rules: {
                                                required: t('component.form.requiredField'),
                                                validate: validateEmail,
                                            }, render: function (_a) {
                                                var field = _a.field;
                                                return (_jsx(EmailInput, __assign({}, field, { "aria-invalid": Boolean(errors.email), "aria-required": 'true', "aria-describedby": "".concat(emailField, "-error"), placeholder: t('form.registeredServerForm.fields.accountEmail.inputPlaceholder'), id: emailField })));
                                            } }) }), errors.email && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(emailField, "-error"), children: t('component.form.requiredField') }))] }), _jsx(AgreeTermsField, { agreementField: agreementField, termsHref: termsHref, policyHref: policyHref, control: control, errors: errors }), _jsx("input", __assign({ type: 'hidden' }, register('updates')))] }) }), _jsx(Form.Footer, { children: _jsxs(Box, { display: 'flex', flexDirection: 'column', alignItems: 'flex-start', children: [_jsxs(ButtonGroup, { vertical: isMobile, children: [_jsx(Button, { type: 'submit', primary: true, loading: isSubmitting || isValidating, disabled: offline, children: t('component.form.action.registerWorkspace') }), offline && (_jsx(Button, { type: 'button', disabled: !offline, onClick: onClickRegisterOffline, children: t('component.form.action.registerOffline') }))] }), _jsx(Box, { id: "".concat(formId, "-engagement-disclaimer"), mbs: 24, fontScale: 'c1', children: t('form.registeredServerForm.registrationEngagement') }), _jsx(Box, { id: "".concat(formId, "-informed-disclaimer"), mbs: 24, fontScale: 'c1', children: _jsxs(Trans, { i18nKey: 'form.registeredServerForm.registrationKeepInformed', children: ["By submitting this form you consent to receive more information about Rocket.Chat products, events and updates, according to our", _jsx("a", { href: policyHref, target: '_blank', rel: 'noopener noreferrer', children: "Privacy Policy" }), ". You may unsubscribe at any time."] }) })] }) })] }) })));
};
export default RegisterServerForm;
//# sourceMappingURL=RegisterServerForm.js.map