import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Box, Button, ButtonGroup, Scrollable } from '@rocket.chat/fuselage';
import { useBreakpoints, useClipboard } from '@rocket.chat/fuselage-hooks';
import { Form } from '@rocket.chat/layout';
import { useId } from 'react';
import { useFormContext } from 'react-hook-form';
import { Trans, useTranslation } from 'react-i18next';
import AgreeTermsField from '../../../common/AgreeTermsField';
import { Steps } from '../RegisterOfflineForm';
var CopyStep = function (_a) {
    var _b = _a.termsHref, termsHref = _b === void 0 ? 'https://rocket.chat/terms' : _b, _c = _a.policyHref, policyHref = _c === void 0 ? 'https://rocket.chat/privacy' : _c, clientKey = _a.clientKey, setStep = _a.setStep, onCopySecurityCode = _a.onCopySecurityCode, onBackButtonClick = _a.onBackButtonClick;
    var t = useTranslation().t;
    var agreementField = useId();
    var breakpoints = useBreakpoints();
    var isMobile = !breakpoints.includes('md');
    var _d = useFormContext(), control = _d.control, _e = _d.formState, isValid = _e.isValid, errors = _e.errors;
    var clipboard = useClipboard(clientKey);
    return (_jsxs(_Fragment, { children: [_jsxs(Form.Container, { children: [_jsx(Box, { mbe: '24px', fontScale: 'p2', children: _jsxs(Trans, { children: ["If for any reason your workspace can\u2019t be connected to the internet, follow these steps:", _jsx(Box, { mbe: '24px' }), "1. Go to: ", _jsx("strong", { children: 'cloud.rocket.chat > Workspaces' }), " and click \u201C", _jsx("strong", { children: "Register self-managed" }), "\u201D", _jsx("br", {}), "2. Click \u201C", _jsx("strong", { children: "Continue offline" }), "\u201D", _jsx("br", {}), "3. In the ", _jsx("strong", { children: "Register offline workspace" }), " dialog in cloud.rocket.chat, paste the token in the box below"] }, 'form.registerOfflineForm.copyStep.description') }), _jsxs(Box, { display: 'flex', flexDirection: 'column', alignItems: 'stretch', padding: 16, flexGrow: 1, backgroundColor: 'dark', children: [_jsx(Scrollable, { vertical: true, children: _jsx(Box, { height: 'x108', fontFamily: 'mono', fontScale: 'p2', color: 'white', style: { wordBreak: 'break-all' }, children: clientKey }) }), _jsx(Button, { icon: 'copy', primary: true, onClick: function () {
                                    onCopySecurityCode();
                                    clipboard.copy();
                                } })] }), _jsx(AgreeTermsField, { agreementField: agreementField, termsHref: termsHref, policyHref: policyHref, control: control, errors: errors })] }), _jsx(Form.Footer, { children: _jsx(Box, { display: 'flex', flexDirection: 'column', children: _jsxs(ButtonGroup, { vertical: isMobile, children: [_jsx(Button, { type: 'button', primary: true, disabled: !isValid, onClick: function () {
                                    setStep(Steps.PASTE);
                                }, children: t('component.form.action.next') }), _jsx(Button, { type: 'button', onClick: onBackButtonClick, children: t('component.form.action.back') })] }) }) })] }));
};
export default CopyStep;
//# sourceMappingURL=CopyStep.js.map