var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { FieldError, FieldLabel, FieldRow, FieldGroup, Field, ButtonGroup, Button, TextInput, Select, Box, } from '@rocket.chat/fuselage';
import { useBreakpoints } from '@rocket.chat/fuselage-hooks';
import { ActionLink, Form } from '@rocket.chat/layout';
import { useRef, useEffect, useId } from 'react';
import { useForm, Controller } from 'react-hook-form';
import { useTranslation } from 'react-i18next';
var OrganizationInfoForm = function (_a) {
    var currentStep = _a.currentStep, stepCount = _a.stepCount, organizationIndustryOptions = _a.organizationIndustryOptions, organizationSizeOptions = _a.organizationSizeOptions, countryOptions = _a.countryOptions, nextStep = _a.nextStep, initialValues = _a.initialValues, onSubmit = _a.onSubmit, onBackButtonClick = _a.onBackButtonClick, onClickSkip = _a.onClickSkip;
    var t = useTranslation().t;
    var breakpoints = useBreakpoints();
    var isMobile = !breakpoints.includes('md');
    var formId = useId();
    var organizationNameField = useId();
    var organizationIndustryField = useId();
    var organizationSizeField = useId();
    var countryField = useId();
    var organizationInfoFormRef = useRef(null);
    var _b = useForm({
        defaultValues: initialValues,
        mode: 'onBlur',
    }), control = _b.control, handleSubmit = _b.handleSubmit, _c = _b.formState, isValidating = _c.isValidating, isSubmitting = _c.isSubmitting, errors = _c.errors;
    useEffect(function () {
        if (organizationInfoFormRef.current) {
            organizationInfoFormRef.current.focus();
        }
    }, []);
    return (_jsxs(Form, { ref: organizationInfoFormRef, tabIndex: -1, "aria-labelledby": "".concat(formId, "-title"), "aria-describedby": "".concat(formId, "-description"), onSubmit: handleSubmit(onSubmit), children: [_jsxs(Form.Header, { children: [_jsx(Form.Steps, { currentStep: currentStep, stepCount: stepCount }), _jsx(Form.Title, { id: "".concat(formId, "-title"), children: t('form.organizationInfoForm.title') }), _jsx(Form.Subtitle, { id: "".concat(formId, "-description"), children: t('form.organizationInfoForm.subtitle') })] }), _jsx(Form.Container, { children: _jsxs(FieldGroup, { children: [_jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: organizationNameField, children: t('form.organizationInfoForm.fields.organizationName.label') }), _jsx(FieldRow, { children: _jsx(Controller, { name: 'organizationName', control: control, rules: {
                                            required: t('component.form.requiredField'),
                                        }, render: function (_a) {
                                            var field = _a.field;
                                            return (_jsx(TextInput, __assign({}, field, { placeholder: t('form.organizationInfoForm.fields.organizationName.placeholder'), "aria-describedby": "".concat(organizationNameField, "-error}"), "aria-required": 'true', "aria-invalid": Boolean(errors.organizationName), id: organizationNameField })));
                                        } }) }), errors.organizationName && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(organizationNameField, "-error}"), children: t('component.form.requiredField') }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: organizationIndustryField, children: t('form.organizationInfoForm.fields.organizationIndustry.label') }), _jsx(FieldRow, { children: _jsx(Controller, { name: 'organizationIndustry', control: control, rules: { required: t('component.form.requiredField') }, render: function (_a) {
                                            var field = _a.field;
                                            return (_jsx(Select, __assign({}, field, { options: organizationIndustryOptions, placeholder: t('form.organizationInfoForm.fields.organizationIndustry.placeholder'), "aria-required": 'true', "aria-invalid": Boolean(errors.organizationIndustry), "aria-describedby": "".concat(organizationIndustryField, "-error}"), id: organizationIndustryField })));
                                        } }) }), errors.organizationIndustry && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(organizationIndustryField, "-error}"), children: t('component.form.requiredField') }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: organizationSizeField, children: t('form.organizationInfoForm.fields.organizationSize.label') }), _jsx(FieldRow, { children: _jsx(Controller, { name: 'organizationSize', control: control, rules: { required: t('component.form.requiredField') }, render: function (_a) {
                                            var field = _a.field;
                                            return (_jsx(Select, __assign({}, field, { options: organizationSizeOptions, placeholder: t('form.organizationInfoForm.fields.organizationSize.placeholder'), "aria-required": 'true', "aria-invalid": Boolean(errors.organizationSize), "aria-describedby": "".concat(organizationSizeField, "-error}"), id: organizationSizeField })));
                                        } }) }), errors.organizationSize && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(organizationSizeField, "-error}"), children: t('component.form.requiredField') }))] }), _jsxs(Field, { children: [_jsx(FieldLabel, { required: true, htmlFor: countryField, children: t('form.organizationInfoForm.fields.country.label') }), _jsx(FieldRow, { children: _jsx(Controller, { name: 'country', control: control, rules: { required: t('component.form.requiredField') }, render: function (_a) {
                                            var field = _a.field;
                                            return (_jsx(Select, __assign({}, field, { options: countryOptions, placeholder: t('form.organizationInfoForm.fields.country.placeholder'), "aria-required": 'true', "aria-invalid": Boolean(errors.country), "aria-describedby": "".concat(countryField, "-error}"), id: countryField })));
                                        } }) }), errors.country && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(countryField, "-error}"), children: t('component.form.requiredField') }))] })] }) }), _jsx(Form.Footer, { children: _jsxs(ButtonGroup, { vertical: isMobile, children: [onBackButtonClick && (_jsx(Button, { disabled: isSubmitting, onClick: onBackButtonClick, children: t('component.form.action.back') })), _jsx(Button, { type: 'submit', primary: true, loading: isValidating || isSubmitting, children: nextStep !== null && nextStep !== void 0 ? nextStep : t('component.form.action.next') }), onClickSkip && (_jsx(Box, { withTruncatedText: true, flexGrow: 1, children: _jsx(ButtonGroup, { align: 'end', children: _jsx(ActionLink, { onClick: onClickSkip, children: t('component.form.action.skip') }) }) }))] }) })] }));
};
export default OrganizationInfoForm;
//# sourceMappingURL=OrganizationInfoForm.js.map