import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, CheckBox, Field, FieldError, FieldLabel, FieldRow, } from '@rocket.chat/fuselage';
import { Controller } from 'react-hook-form';
import { Trans, useTranslation } from 'react-i18next';
var AgreeTermsField = function (_a) {
    var agreementField = _a.agreementField, termsHref = _a.termsHref, policyHref = _a.policyHref, control = _a.control, errors = _a.errors;
    var t = useTranslation().t;
    return (_jsxs(Field, { mbs: '24px', children: [_jsxs(FieldRow, { justifyContent: 'initial', children: [_jsx(Controller, { name: 'agreement', control: control, rules: {
                            required: t('component.form.requiredField'),
                        }, render: function (_a) {
                            var _b = _a.field, ref = _b.ref, name = _b.name, onBlur = _b.onBlur, onChange = _b.onChange, value = _b.value;
                            return (_jsx(CheckBox, { ref: ref, id: agreementField, onChange: onChange, onBlur: onBlur, name: name, checked: value, "aria-describedby": "".concat(agreementField, "-error"), "aria-invalid": Boolean(errors.agreement), "aria-required": 'true' }));
                        } }), _jsx(FieldLabel, { display: 'inline', htmlFor: agreementField, withRichContent: true, required: true, fontScale: 'c1', mis: 4, children: _jsxs(Trans, { i18nKey: 'component.form.termsAndConditions', children: ["I agree with", _jsx(Box, { is: 'a', href: termsHref, target: '_blank', rel: 'noopener noreferrer', children: "Terms and Conditions" }), "and", _jsx(Box, { is: 'a', href: policyHref, target: '_blank', rel: 'noopener noreferrer', children: "Privacy Policy" })] }) })] }), errors.agreement && (_jsx(FieldError, { "aria-live": 'assertive', id: "".concat(agreementField, "-error"), children: t('component.form.requiredField') }))] }));
};
export default AgreeTermsField;
//# sourceMappingURL=AgreeTermsField.js.map