"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.countryOptions = exports.organizationSizeOptions = exports.organizationIndustryOptions = exports.validatePassword = exports.validateEmail = exports.validateUsername = exports.logSubmit = void 0;
var countries_list_1 = require("countries-list");
var actions_1 = require("storybook/actions");
var logSubmit = function (onSubmit) {
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        (0, actions_1.action)('submit').apply(void 0, args);
        return onSubmit.apply(void 0, args);
    };
};
exports.logSubmit = logSubmit;
var delay = function (ms) { return new Promise(function (resolve) { return setTimeout(resolve, ms); }); };
var simulateNetworkDelay = function () { return delay(3000 * Math.random()); };
var fetchMock = function (endpoint, handler) {
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        (0, actions_1.action)("fetch(".concat(endpoint, ")")).apply(void 0, args);
                        return [4 /*yield*/, simulateNetworkDelay()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, handler.apply(void 0, args)];
                }
            });
        });
    };
};
exports.validateUsername = fetchMock('/username/validate', function (username) {
    if (username === 'admin') {
        return "Username \"".concat(username, "\" is not available");
    }
    return true;
});
exports.validateEmail = fetchMock('/email/validate', function (email) {
    if (email === 'admin@rocket.chat') {
        return "Email \"".concat(email, "\" is already in use");
    }
    return true;
});
var validatePassword = function (password) {
    if (password.length < 6) {
        return "Password is too short";
    }
    return true;
};
exports.validatePassword = validatePassword;
exports.organizationIndustryOptions = [
    ['aerospaceDefense', 'Aerospace and Defense'],
    ['blockchain', 'Blockchain'],
    ['consulting', 'Consulting'],
    ['consumerGoods', 'Consumer Packaged Goods'],
    ['contactCenter', 'Contact Center'],
    ['education', 'Education'],
    ['entertainment', 'Entertainment'],
    ['financialServices', 'Financial Services'],
    ['gaming', 'Gaming'],
    ['healthcare', 'Healthcare'],
    ['hospitalityBusinness', 'Hospitality Businness'],
    ['insurance', 'Insurance'],
    ['itSecurity', 'IT Security'],
    ['logistics', 'Logistics'],
    ['manufacturing', 'Manufacturing'],
    ['media', 'Media'],
    ['pharmaceutical', 'Pharmaceutical'],
    ['realEstate', 'Real Estate'],
    ['religious', 'Religious'],
    ['retail', 'Retail'],
    ['socialNetwork', 'Social Network'],
    ['technologyProvider', 'Technology Provider'],
    ['technologyServices', 'Technology Services'],
    ['telecom', 'Telecom'],
    ['utilities', 'Utilities'],
    ['other', 'Other'],
];
exports.organizationSizeOptions = [
    ['0', '1-250 people'],
    ['1', '251-500 people'],
    ['2', '501-1000 people'],
    ['3', '1001-4000 people'],
    ['4', '4001 or more people'],
];
exports.countryOptions = __spreadArray(__spreadArray([], Object.entries(countries_list_1.countries).map(function (_a) {
    var code = _a[0], name = _a[1].name;
    return [
        code,
        name,
    ];
}), true), [
    ['worldwide', 'Worldwide'],
], false);
//# sourceMappingURL=mocks.js.map