"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyDepartmentRestrictionsPatch = void 0;
const license_1 = require("@rocket.chat/license");
const omni_core_1 = require("@rocket.chat/omni-core");
const addRoleBasedRestrictionsToDepartment_1 = require("../units/addRoleBasedRestrictionsToDepartment");
const logger_1 = require("../utils/logger");
const applyDepartmentRestrictionsPatch = () => {
    omni_core_1.applyDepartmentRestrictions.patch(async (prev, query = {}, userId) => {
        if (!license_1.License.hasModule('livechat-enterprise')) {
            return prev(query, userId);
        }
        logger_1.hooksLogger.debug('Applying department query restrictions');
        return (0, addRoleBasedRestrictionsToDepartment_1.addQueryRestrictionsToDepartmentsModel)(query, userId);
    });
};
exports.applyDepartmentRestrictionsPatch = applyDepartmentRestrictionsPatch;
//# sourceMappingURL=applyDepartmentRestrictions.js.map