"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDepartmentCreationAvailablePatch = isDepartmentCreationAvailablePatch;
const license_1 = require("@rocket.chat/license");
const omni_core_1 = require("@rocket.chat/omni-core");
function isDepartmentCreationAvailablePatch() {
    omni_core_1.isDepartmentCreationAvailable.patch(async (next) => {
        // Skip the standard check when Livechat Enterprise is enabled, as it allows unlimited departments
        if (license_1.License.hasModule('livechat-enterprise')) {
            return true;
        }
        return next();
    });
}
//# sourceMappingURL=isDepartmentCreationAvailable.js.map