"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdaterImpl = void 0;
class UpdaterImpl {
    constructor() {
        this.dirty = false;
    }
    set(key, value) {
        this._set = this._set ?? new Map();
        this._set.set(key, value);
        return this;
    }
    unset(key) {
        this._unset = this._unset ?? new Set();
        this._unset.add(key);
        return this;
    }
    inc(key, value) {
        this._inc = this._inc ?? new Map();
        const prev = this._inc.get(key) ?? 0;
        this._inc.set(key, prev + value);
        return this;
    }
    addToSet(key, value) {
        this._addToSet = this._addToSet ?? new Map();
        const prev = this._addToSet.get(key) ?? [];
        this._addToSet.set(key, [...prev, value]);
        return this;
    }
    hasChanges() {
        const filter = this.getRawUpdateFilter();
        return this._hasChanges(filter);
    }
    _hasChanges(filter) {
        return Object.keys(filter).length > 0;
    }
    getRawUpdateFilter() {
        return {
            ...(this._set && { $set: Object.fromEntries(this._set) }),
            ...(this._unset && { $unset: Object.fromEntries([...this._unset.values()].map((k) => [k, 1])) }),
            ...(this._inc && { $inc: Object.fromEntries(this._inc) }),
            ...(this._addToSet && { $addToSet: Object.fromEntries([...this._addToSet.entries()].map(([k, v]) => [k, { $each: v }])) }),
        };
    }
    getUpdateFilter() {
        if (this.dirty) {
            throw new Error('Updater is dirty');
        }
        this.dirty = true;
        const filter = this.getRawUpdateFilter();
        if (!this._hasChanges(filter)) {
            throw new Error('No changes to update');
        }
        return filter;
    }
}
exports.UpdaterImpl = UpdaterImpl;
//# sourceMappingURL=updater.js.map