"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatisticsRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class StatisticsRaw extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, 'statistics');
    }
    modelIndexes() {
        return [{ key: { createdAt: -1 } }];
    }
    async findLast() {
        const records = await this.find({}, {
            sort: {
                createdAt: -1,
            },
            limit: 1,
        }).toArray();
        return records?.[0];
    }
    async findLastStatsToken() {
        const records = await this.find({
            statsToken: { $exists: true },
        }, {
            sort: {
                createdAt: -1,
            },
            projection: {
                statsToken: 1,
            },
            limit: 1,
        }).toArray();
        return records?.[0]?.statsToken;
    }
    async findMonthlyPeakConnections() {
        const oneMonthAgo = new Date();
        oneMonthAgo.setDate(oneMonthAgo.getDate() - 30);
        oneMonthAgo.setHours(0, 0, 0, 0);
        return this.findOne({
            createdAt: { $gte: oneMonthAgo },
        }, {
            sort: {
                dailyPeakConnections: -1,
            },
            projection: {
                dailyPeakConnections: 1,
                createdAt: 1,
            },
        });
    }
    async findInstallationDates() {
        return this.col
            .aggregate([
            {
                $group: {
                    _id: '$version',
                    installedAt: { $min: '$installedAt' },
                },
            },
            {
                $project: {
                    _id: 0,
                    version: '$_id',
                    installedAt: 1,
                },
            },
            {
                $sort: { installedAt: 1 },
            },
        ])
            .toArray();
    }
}
exports.StatisticsRaw = StatisticsRaw;
//# sourceMappingURL=Statistics.js.map