"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerEventsRaw = void 0;
const core_typings_1 = require("@rocket.chat/core-typings");
const BaseRaw_1 = require("./BaseRaw");
class ServerEventsRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'server_events', trash);
    }
    modelIndexes() {
        return [{ key: { t: 1, ip: 1, ts: -1 } }, { key: { 't': 1, 'u.username': 1, 'ts': -1 } }];
    }
    async findLastFailedAttemptByIp(ip) {
        return this.findOne({
            ip,
            t: core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
        }, { sort: { ts: -1 } });
    }
    async findLastFailedAttemptByUsername(username) {
        return this.findOne({
            'u.username': username,
            't': core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
        }, { sort: { ts: -1 } });
    }
    async findLastSuccessfulAttemptByIp(ip) {
        return this.findOne({
            ip,
            t: core_typings_1.ServerEventType.LOGIN,
        }, { sort: { ts: -1 } });
    }
    async findLastSuccessfulAttemptByUsername(username) {
        return this.findOne({
            'u.username': username,
            't': core_typings_1.ServerEventType.LOGIN,
        }, { sort: { ts: -1 } });
    }
    async countFailedAttemptsByUsernameSince(username, since) {
        return this.countDocuments({
            'u.username': username,
            't': core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
            'ts': {
                $gte: since,
            },
        });
    }
    countFailedAttemptsByIpSince(ip, since) {
        return this.countDocuments({
            ip,
            t: core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
            ts: {
                $gte: since,
            },
        });
    }
    countFailedAttemptsByIp(ip) {
        return this.countDocuments({
            ip,
            t: core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
        });
    }
    countFailedAttemptsByUsername(username) {
        return this.countDocuments({
            'u.username': username,
            't': core_typings_1.ServerEventType.FAILED_LOGIN_ATTEMPT,
        });
    }
    async createAuditServerEvent(key, data, actor) {
        await this.insertOne({
            t: key,
            ts: new Date(),
            actor,
            data: Object.entries(data).map(([key, value]) => ({ key, value })),
            // deprecated just to keep backward compatibility
            ip: '0.0.0.0',
            ...(actor.type === 'user' && { ip: actor?.ip || '0.0.0.0', u: { _id: actor._id, username: actor.username } }),
        });
    }
}
exports.ServerEventsRaw = ServerEventsRaw;
//# sourceMappingURL=ServerEvents.js.map