"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OEmbedCacheRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class OEmbedCacheRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'oembed_cache', trash);
    }
    modelIndexes() {
        return [{ key: { updatedAt: 1 } }];
    }
    async createWithIdAndData(_id, data) {
        const record = {
            _id,
            data,
            updatedAt: new Date(),
        };
        record._id = (await this.insertOne(record)).insertedId;
        return record;
    }
    removeBeforeDate(date) {
        const query = {
            updatedAt: {
                $lte: date,
            },
        };
        return this.deleteMany(query);
    }
}
exports.OEmbedCacheRaw = OEmbedCacheRaw;
//# sourceMappingURL=OEmbedCache.js.map