"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthAccessTokensRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class OAuthAccessTokensRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'oauth_access_tokens', trash);
    }
    modelIndexes() {
        return [
            { key: { accessToken: 1 } },
            { key: { refreshToken: 1 } },
            { key: { expires: 1 }, expireAfterSeconds: 60 * 60 * 24 * 30 },
            { key: { refreshTokenExpiresAt: 1 }, expireAfterSeconds: 60 * 60 * 24 * 30 },
        ];
    }
    async findOneByAccessToken(accessToken, options) {
        if (!accessToken) {
            return null;
        }
        return this.findOne({ accessToken }, options);
    }
    async findOneByRefreshToken(refreshToken, options) {
        if (!refreshToken) {
            return null;
        }
        return this.findOne({ refreshToken }, options);
    }
}
exports.OAuthAccessTokensRaw = OAuthAccessTokensRaw;
//# sourceMappingURL=OAuthAccessTokens.js.map