"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationQueueRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class NotificationQueueRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'notification_queue', trash);
    }
    modelIndexes() {
        return [
            { key: { uid: 1 } },
            { key: { ts: 1 }, expireAfterSeconds: 2 * 60 * 60 },
            { key: { schedule: 1 }, sparse: true },
            { key: { sending: 1 }, sparse: true },
            { key: { error: 1 }, sparse: true },
        ];
    }
    unsetSendingById(_id) {
        return this.updateOne({ _id }, {
            $unset: {
                sending: 1,
            },
        });
    }
    setErrorById(_id, error) {
        return this.updateOne({
            _id,
        }, {
            $set: {
                error,
            },
            $unset: {
                sending: 1,
            },
        });
    }
    clearScheduleByUserId(uid) {
        return this.updateMany({
            uid,
            schedule: { $exists: true },
        }, {
            $unset: {
                schedule: 1,
            },
        });
    }
    async clearQueueByUserId(uid) {
        const op = await this.deleteMany({
            uid,
        });
        return op.deletedCount;
    }
    async findNextInQueueOrExpired(expired) {
        const now = new Date();
        const result = await this.findOneAndUpdate({
            $and: [
                {
                    $or: [{ sending: { $exists: false } }, { sending: { $lte: expired } }],
                },
                {
                    $or: [{ schedule: { $exists: false } }, { schedule: { $lte: now } }],
                },
                {
                    error: { $exists: false },
                },
            ],
        }, {
            $set: {
                sending: now,
            },
        }, {
            sort: {
                ts: 1,
            },
        });
        return result;
    }
}
exports.NotificationQueueRaw = NotificationQueueRaw;
//# sourceMappingURL=NotificationQueue.js.map