"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaCallNegotiationsRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class MediaCallNegotiationsRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'media_call_negotiations', trash);
    }
    modelIndexes() {
        return [{ key: { callId: 1, requestTimestamp: -1 }, unique: false }];
    }
    async findLatestByCallId(callId, options) {
        return this.findOne({
            callId,
        }, {
            ...options,
            sort: {
                requestTimestamp: -1,
            },
            limit: 1,
        });
    }
    async setOfferById(id, offer) {
        return this.updateOne({
            _id: id,
            offer: { $exists: false },
        }, {
            $set: {
                offer,
                offerTimestamp: new Date(),
            },
        });
    }
    async setAnswerById(id, answer) {
        return this.updateOne({
            _id: id,
            answer: { $exists: false },
        }, {
            $set: {
                answer,
                answerTimestamp: new Date(),
            },
        });
    }
    async setStableById(id) {
        return this.updateOne({
            _id: id,
            stableTimestamp: { $exists: false },
        }, {
            $set: {
                stableTimestamp: new Date(),
            },
        });
    }
}
exports.MediaCallNegotiationsRaw = MediaCallNegotiationsRaw;
//# sourceMappingURL=MediaCallNegotiations.js.map