"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginServiceConfigurationRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class LoginServiceConfigurationRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'meteor_accounts_loginServiceConfiguration', trash, {
            preventSetUpdatedAt: true,
            collectionNameResolver(name) {
                return name;
            },
        });
    }
    async createOrUpdateService(serviceName, serviceData) {
        const service = serviceName.toLowerCase();
        const existing = await this.findOne({ service });
        if (!existing) {
            const insertResult = await this.insertOne({
                service,
                ...serviceData,
            });
            return insertResult.insertedId;
        }
        if (Object.keys(serviceData).length > 0) {
            await this.updateOne({
                _id: existing._id,
            }, {
                $set: serviceData,
            });
        }
        return existing._id;
    }
    async removeService(_id) {
        return this.deleteOne({ _id });
    }
    async findOneByService(serviceName, options) {
        return this.findOne({ service: serviceName.toLowerCase() }, options);
    }
}
exports.LoginServiceConfigurationRaw = LoginServiceConfigurationRaw;
//# sourceMappingURL=LoginServiceConfiguration.js.map