"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LivechatPriorityRaw = void 0;
const string_helpers_1 = require("@rocket.chat/string-helpers");
const BaseRaw_1 = require("./BaseRaw");
// TODO need to define type for LivechatPriority object
class LivechatPriorityRaw extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, 'livechat_priority');
    }
    modelIndexes() {
        return [
            {
                key: {
                    name: 1,
                },
                unique: true,
                partialFilterExpression: {
                    $and: [{ name: { $exists: true } }, { name: { $gt: '' } }],
                },
            },
        ];
    }
    findOneByIdOrName(_idOrName, options = {}) {
        const query = {
            $or: [
                {
                    _id: _idOrName,
                },
                {
                    name: _idOrName,
                },
            ],
        };
        return this.findOne(query, options);
    }
    findOneNameUsingRegex(_idOrName, options = {}) {
        const query = {
            name: new RegExp(`^${(0, string_helpers_1.escapeRegExp)(_idOrName.trim())}$`, 'i'),
        };
        return this.findOne(query, options);
    }
    findByDirty() {
        return this.find({ dirty: true }, { projection: { _id: 1 } });
    }
    async canResetPriorities() {
        return Boolean(await this.findOne({ dirty: true }, { projection: { _id: 1 } }));
    }
    async resetPriorities(ids) {
        await this.updateMany({ _id: { $in: ids } }, [{ $set: { dirty: false } }, { $unset: 'name' }]);
    }
    async updatePriority(_id, reset, name) {
        const query = {
            _id,
        };
        const update = {
            ...((reset && {
                $set: { dirty: false },
                $unset: { name: 1 },
            }) || {
                // Trim value before inserting
                $set: { name: name?.trim(), dirty: true },
            }),
        };
        return this.findOneAndUpdate(query, update, {
            returnDocument: 'after',
        });
    }
}
exports.LivechatPriorityRaw = LivechatPriorityRaw;
//# sourceMappingURL=LivechatPriority.js.map