"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvitesRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class InvitesRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'invites', trash);
    }
    findOneByUserRoomMaxUsesAndExpiration(userId, rid, maxUses, daysToExpire) {
        return this.findOne({
            rid,
            userId,
            days: daysToExpire,
            maxUses,
            ...(daysToExpire > 0 ? { expires: { $gt: new Date() } } : {}),
            ...(maxUses > 0 ? { uses: { $lt: maxUses } } : {}),
        });
    }
    increaseUsageById(_id, uses = 1) {
        return this.updateOne({ _id }, {
            $inc: {
                uses,
            },
        });
    }
    async countUses() {
        const [result] = await this.col.aggregate([{ $group: { _id: null, totalUses: { $sum: '$uses' } } }]).toArray();
        return result?.totalUses || 0;
    }
}
exports.InvitesRaw = InvitesRaw;
//# sourceMappingURL=Invites.js.map