"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportsModel = void 0;
const BaseRaw_1 = require("./BaseRaw");
class ImportsModel extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, 'import');
    }
    modelIndexes() {
        return [{ key: { ts: -1 } }, { key: { valid: 1 } }];
    }
    async findLastImport() {
        const imports = await this.find({}, { sort: { ts: -1 }, limit: 1 }).toArray();
        return imports.shift();
    }
    async hasValidOperationInStatus(allowedStatus) {
        return Boolean(await this.findOne({
            valid: { $ne: false },
            status: { $in: allowedStatus },
        }, { projection: { _id: 1 } }));
    }
    invalidateAllOperations() {
        return this.updateMany({ valid: { $ne: false } }, { $set: { valid: false } });
    }
    invalidateOperationsExceptId(id) {
        return this.updateMany({ valid: { $ne: false }, _id: { $ne: id } }, { $set: { valid: false } });
    }
    findAllPendingOperations(options = {}) {
        return this.find({ valid: true }, options);
    }
    async increaseTotalCount(id, recordType, increaseBy = 1) {
        return this.updateOne({ _id: id }, {
            $inc: {
                'count.total': increaseBy,
                [`count.${recordType}`]: increaseBy,
            },
        });
    }
    async setOperationStatus(id, status) {
        return this.updateOne({ _id: id }, {
            $set: {
                status,
            },
        });
    }
}
exports.ImportsModel = ImportsModel;
//# sourceMappingURL=Imports.js.map