"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeSwitchChannelEventDeltaRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class FreeSwitchChannelEventDeltaRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'freeswitch_channel_event_deltas', trash);
    }
    modelIndexes() {
        return [
            { key: { channelUniqueId: 1, sequence: 1 }, unique: true },
            // Keep event deltas for 30 days
            { key: { _updatedAt: 1 }, expireAfterSeconds: 30 * 24 * 60 * 60 },
        ];
    }
    async registerDelta(delta) {
        return this.insertOne(delta);
    }
}
exports.FreeSwitchChannelEventDeltaRaw = FreeSwitchChannelEventDeltaRaw;
//# sourceMappingURL=FreeSwitchChannelEventDelta.js.map