"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeSwitchChannelEventRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class FreeSwitchChannelEventRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'freeswitch_channel_events', trash);
    }
    modelIndexes() {
        return [
            { key: { channelUniqueId: 1, sequence: 1 }, unique: true },
            // Allow 3 days of events to be saved
            { key: { receivedAt: 1 }, expireAfterSeconds: 3 * 24 * 60 * 60 },
        ];
    }
    async registerEvent(event) {
        return this.insertOne(event);
    }
    findAllByChannelUniqueId(channelUniqueId, options) {
        const theOptions = {
            sort: {
                sequence: 1,
            },
            ...options,
        };
        return this.find({
            channelUniqueId,
        }, theOptions);
    }
}
exports.FreeSwitchChannelEventRaw = FreeSwitchChannelEventRaw;
//# sourceMappingURL=FreeSwitchChannelEvent.js.map